/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoPromocional;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.ArrayList;

public class MicSolicitacaoCargaProdutosPromocionais {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        SaidaApiTefC saida;
        boolean flagCarga;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ContextoCTFClient contexto = Contexto.getContexto();
        EntradaApiTefC entrada = contexto.getEntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        if (contexto.getEntradaIntegracao() != null) {
            EntradaCTFClientCtrl entradaIntegracao = contexto.getEntradaIntegracao();
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
            if (entradaIntegracao.isTimestampProdutosPromocionaisCtrl()) {
                entrada.setTimestampProdutosPromocionais(entradaIntegracao.getTimestampProdutosPromocionais());
            } else {
                entrada.setTimestampProdutosPromocionais("00000000000000");
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (conf.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(conf.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        int retries = 0;
        int maxRetries = 3;
        int indiceCargaProdutos = 0;
        ArrayList<ProdutoPromocional> listProdutos = new ArrayList<ProdutoPromocional>();
        do {
            entrada.setIndiceCargaTabelaPin(indiceCargaProdutos);
            logger.info("Solicitando carga de produtos sequencial: " + indiceCargaProdutos + ".");
            saida = dados.getApitef().solicitacao(ident, entrada);
            Contexto.getContexto().setSaidaApiTefC(saida);
            flagCarga = saida.isCargaProdutosPromocionais();
            if (saida.getRetorno() == 0) {
                retries = 0;
                indiceCargaProdutos = saida.getIndiceTabelaPinpad();
                listProdutos.addAll(saida.getProdutosPromocionais());
                continue;
            }
            flagCarga = true;
            logger.warn("Erro na tentativa de carga de produtos. Efetuando tentativa " + ++retries + " de " + maxRetries + ".");
        } while (flagCarga && retries < maxRetries);
        logger.info("Quantidade de produtos recebido na(s) consulta(s): " + listProdutos.size());
        if (saida.getRetorno() != 0) {
            logger.info("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        saida.setProdutosPromocionais(listProdutos);
        return SUCCESS;
    }

    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        return "AF";
    }
}

