/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Date;

public class MicSolicitacaoBypass {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
        periferico.imprimeDisplay(displayModel);
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            entrada.setDataCliente(Contexto.getContexto().getEntradaIntegracao().getDataAbertura());
            if (Contexto.getContexto().getEntradaIntegracao().isInfoAdicionaisCtrl()) {
                entrada.setAdicionais(Contexto.getContexto().getEntradaIntegracao().getInfoAdicionais());
            }
            if (Contexto.getContexto().getEntradaIntegracao().isTipoGarantiaCtrl()) {
                entrada.setTipoGarantia(Contexto.getContexto().getEntradaIntegracao().getTipoGarantia());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        try {
            SaidaGetInfoEMV getInfo = periferico.getPinpad().getInfo();
            if (getInfo != null) {
                entrada.setNumeroSeriePin(getInfo.getNumSeriePinpad());
                entrada.setRetornoGetInfo(getInfo.getRetorno());
            }
            entrada.setTipoPin("16");
        }
        catch (ExcecaoPerifericos e) {
            logger.warn("Nao foi possivel carregar as informacoes do pin: " + e.getMessage());
            entrada.setTipoPin("**");
        }
        int timeout = Contexto.getContexto().getSaidaApiTefC() != null ? Contexto.getContexto().getSaidaApiTefC().getTimeOutCTF() : 28;
        entrada.setTimeoutCtf(timeout);
        entrada.setTimestamp(new Date());
        if (entradaIntegracao.isCodigoAutorizadoraCtrl()) {
            entrada.setCodigoAutorizadora(entradaIntegracao.getCodigoAutorizadora());
            entrada.setInfo(this.trataCodigoOperadoraInfo(entrada.getInfo(), entradaIntegracao.getCodigoAutorizadora()));
        }
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        if (saidaApiTefC.getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
            return SUCESS;
        }
        logger.info("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
        return ERROR;
    }

    protected String getCodigoTransacao(Process dados) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoTransacaoCtrl()) {
            return entradaIntegracao.getCodigoTransacao();
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }

    private String trataCodigoOperadoraInfo(String info, String codigoAutorizadora) {
        if (info == null) {
            info = "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = info.length(); i < 68; ++i) {
            sb.append("0");
        }
        if (codigoAutorizadora.length() == 1) {
            codigoAutorizadora = codigoAutorizadora + " ";
        }
        return info + sb.toString() + codigoAutorizadora;
    }
}

