/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.ArrayList;

public class MicSelectTransaction {
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String CREDITO = "CREDITO";
    public static final String DEBITO = "DEBITO";
    private static final String DESCRIPTION_TITLE = "SELECIONE A OPERACAO:";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add(CREDITO);
        descriptions.add(DEBITO);
        if (!StringUtil.isEmpty(Contexto.getContexto().getTipoOperacao())) {
            logger.debug("Tipo da opera\u00e7\u00e3o j\u00e1 preenchido = " + Contexto.getContexto().getTipoOperacao());
        } else {
            int selectedTypeIndex = perifericos.showSingleChoiceMenu(dados, DESCRIPTION_TITLE, descriptions);
            logger.debug("\u00cdndice de opera\u00e7\u00e3o selecionada = " + selectedTypeIndex);
            if (selectedTypeIndex == -1) {
                logger.info("Sele\u00e7\u00e3o de opera\u00e7\u00e3o cancelada pelo usu\u00e1rio");
                return USER_CANCEL;
            }
            if (selectedTypeIndex == 0) {
                Contexto.getContexto().setTipoOperacao(OperationEnum.OP_CREDITO_GENERICO.getDescription());
            } else if (selectedTypeIndex == 1) {
                Contexto.getContexto().setTipoOperacao(OperationEnum.OP_DEBITO_GENERICO.getDescription());
            }
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO_GENERICO.getDescription())) {
            return CREDITO;
        }
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEBITO_GENERICO.getDescription())) {
            return DEBITO;
        }
        return ERROR;
    }
}

