/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.CodigoRespostaAutorizadora;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.model.constants.IEMVMessageErrorCode;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ComunicacaoHost;
import com.csi.ctfclient.apitef.model.TipoResposta;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.DecisaoFinishChip;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MicRemoveCard
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private String msgDisplay;
    private String msgPinPad;

    @Override
    public String derivedExecute(Process dado) throws ExcecaoNaoLocal {
        int redeChip = 0;
        PinEMV pin = this.tryGetPin();
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        ControladorPerifericos perifericos = dado.getPerifericos();
        IEMVMessageErrorCode errorCode = IEMVMessageErrorCode.getEnumByKey(Contexto.getContexto().getErrorCode(), config.getTipoIntegracaoEnum());
        boolean connectedPin = perifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isConsulta() && saida != null && saida.getRetorno() == 0) {
            this.logger.debug(":: Transacao de Consulta");
            return SUCESS;
        }
        if (entradaApiTefC != null && entradaApiTefC.getCodigoRedeAdquirenteChip() != null && !"".equals(entradaApiTefC.getCodigoRedeAdquirenteChip())) {
            redeChip = Integer.parseInt(entradaApiTefC.getCodigoRedeAdquirenteChip());
        }
        this.logger.info(errorCode + " connectedPin:" + connectedPin + " redeChip:" + redeChip);
        if (EMVResponseCode.PP_CONTINUE.equals((Object)errorCode.getEmvResponseCode())) {
            return SUCESS;
        }
        this.validEMVMessageErrorCode(redeChip, saida, entradaApiTefC, pin, Contexto.getContexto(), errorCode);
        this.logger.info("msgDisplay={} msgPinPad={}", this.msgDisplay, this.msgPinPad);
        if (connectedPin) {
            BibliotecaPinpad pinPad = (BibliotecaPinpad)pin;
            try {
                this.exibeMsgDisplay(this.msgDisplay, perifericos, 0L);
                pinPad.removeCard(this.msgPinPad);
                Thread.sleep(ControladorConfCTFClient.TIME_OUT_DELAY);
                pinPad.setMsgDisplay(pinPad.getMsgPrompt());
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                this.logger.error((Object)("Erro ao chamar a RemoveCard: " + excecaoPerifericos.getMessage()), excecaoPerifericos);
                return ERROR;
            }
            catch (InterruptedException e) {
                this.logger.error(e);
                return ERROR;
            }
        } else {
            this.exibeMsgDisplay(this.msgDisplay, perifericos, ControladorConfCTFClient.TIME_OUT_DELAY);
        }
        Contexto.getContexto().setErrorCode(EMVResponseCode.PP_CONTINUE.getId());
        return SUCESS;
    }

    private void exibeMsgDisplay(String msgDisplay, ControladorPerifericos perifericos, long timeOut) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msgDisplay, timeOut);
        perifericos.imprimeDisplay(displayModel);
    }

    private void validEMVMessageErrorCode(int redeChip, SaidaApiTefC saida, EntradaApiTefC entradaApiTefC, PinEMV pin, ContextoCTFClient contexto, IEMVMessageErrorCode errorCode) {
        switch (errorCode.getEmvResponseCode()) {
            case PP_OK: {
                if (saida != null) {
                    if (saida.getRetorno() == 0) {
                        this.logger.info("validEMVMessageErrorCode: PP_OK: retorno: 0");
                        this.changesMessage(errorCode.getMsgDisplay(), this.returnRemoveCardMessage(errorCode.getMsgPinPad(), contexto));
                        break;
                    }
                    if (Arrays.asList(CodigoRespostaAutorizadora.NEGADA_CARTAO.getCodes()).contains(saida.getCodigoRespostaAutorizadora()) || entradaApiTefC != null && TipoResposta.CARTAO.getCodigo().equals(entradaApiTefC.getTipoResposta())) {
                        if (redeChip == 2) {
                            this.logger.info("validEMVMessageErrorCode: PP_OK: Trata mensagem negada cartao: MSG_NEGADA_CARTAO_LIGUE_EMISSOR");
                            this.changesMessage("TRANSACAO NEGADA LIGUE EMISSOR", errorCode.getMsgPinPad());
                            break;
                        }
                        if (redeChip == 3) {
                            this.logger.info("validEMVMessageErrorCode: PP_OK: Trata mensagem negada cartao");
                            this.changesMessage(this.returnRemoveCardMessage("TRANS. NAO AUT. PELO CARTAO", contexto), this.returnRemoveCardMessage(errorCode.getMsgPinPad(), contexto));
                            break;
                        }
                        this.logger.info("validEMVMessageErrorCode: PP_OK: Trata mensagem negada cartao: MSG_NEGADA_CARTAO");
                        this.changesMessage("TRANS. NAO AUT. PELO CARTAO", errorCode.getMsgPinPad());
                        break;
                    }
                    if (saida.getRetorno() == 1 && contexto.getPinInfo() != null && DecisaoFinishChip.TRANSACAO_APROVADA_OFFLINE.getCodigo() == contexto.getPinInfo().getDecisaoFinishChip() && pin != null && pin.getComunicacaoHost() == ComunicacaoHost.CONN_FAIL.getCodigo()) {
                        this.logger.info("validEMVMessageErrorCode: PP_OK: Tratar solicitacao de aprovacao offline que ocorreu timeout com ctf");
                        this.changesMessage(errorCode.getMsgDisplay(), InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_AUT_CARTAO));
                        break;
                    }
                    this.logger.info("validEMVMessageErrorCode: PP_OK: retorno: " + saida.getRetorno());
                    this.changesMessage(errorCode.getMsgDisplay(), this.returnRemoveCardMessage(errorCode.getMsgPinPad(), contexto));
                    break;
                }
                this.logger.info("validEMVMessageErrorCode: PP_OK: saida: " + null);
                this.changesMessage(errorCode.getMsgDisplay(), this.returnRemoveCardMessage(errorCode.getMsgPinPad(), contexto));
                break;
            }
            case PPC_ERRFALBACK: {
                if (contexto.getCartao() != null && contexto.getCartao() != Cartao.CHIP && redeChip == 2) {
                    this.logger.info("validEMVMessageErrorCode: PPC_ERRFALBACK: Cartao: " + (Object)((Object)contexto.getCartao()));
                    this.changesMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_OPER_FALLBACK), InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_PINPAD_FALLBACK));
                    break;
                }
                this.changesMessage(errorCode.getMsgDisplay(), errorCode.getMsgPinPad());
                break;
            }
            case PP_SAMERR: {
                this.changesMessage(errorCode.getMsgDisplay(), this.returnRemoveCardMessage(errorCode.getMsgPinPad(), contexto));
                break;
            }
            case PP_NONRESP: {
                this.logger.trace("validEMVMessageErrorCode: PP_NONRESP: mensagem padr\u00e3o para erros desconhecidos");
                this.changesMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_OPER_REMOVE_DEFAULT), StringUtils.join(errorCode.getMsgPinPad(), " ", Integer.valueOf(contexto.getErrorCode())));
                break;
            }
            default: {
                this.logger.trace("validEMVMessageErrorCode: DEFAULT");
                this.changesMessage(errorCode.getMsgDisplay(), errorCode.getMsgPinPad());
            }
        }
    }

    private void changesMessage(String msgDisplay, String msgPinpad) {
        this.logger.debug("changesMessage: msgDisplay: {} msgPinPad: {}", msgDisplay, msgPinpad);
        this.msgDisplay = msgDisplay;
        this.msgPinPad = msgPinpad;
    }

    private String returnRemoveCardMessage(String msgPinpad, ContextoCTFClient contexto) {
        if (contexto.getRemoveCardMessage() != null && contexto.getRemoveCardMessage().length() > 0) {
            this.logger.debug("returnRemoveCardMessage: RemoveCardMessage: " + contexto.getRemoveCardMessage());
            return contexto.getRemoveCardMessage();
        }
        this.logger.debug("returnRemoveCardMessage: msgPinpad: " + msgPinpad);
        return msgPinpad;
    }
}

