/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.MensagensPagamentoParcial;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.DecimalFormat;

public class MicQuestionaSaldoParcial {
    public static final String SUCCESS = "SUCCESS";
    public static final String DENIED = "DENIED";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        logger.debug("Pagamento com saldo parcial permitido pela automa\u00e7\u00e3o e pelo TEF");
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        String valorTransacaoFormatado = format.format(entradaApiTefC.getValorTransacao().doubleValue());
        String valorSaldoFormatado = format.format(saidaApiTefC.getValorTransacao().doubleValue());
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("SALDO INSUFICIENTE PARA PAGAMENTO"));
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha("VALOR VENDA:  " + valorTransacaoFormatado));
        displayModel.addLinha(new Linha("SALDO CARTAO: " + valorSaldoFormatado));
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.QUEVOUSALPAR_TITLE)));
        MensagensPagamentoParcial mensagensPagamentoParcial = MensagensPagamentoParcial.getEnumByKey(OperationEnum.getEnumByDescription(Contexto.getContexto().getTipoOperacao()));
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            Contexto.getContexto().setErroIntegracao(mensagensPagamentoParcial.getCodigoErroIntegracao());
            entradaApiTefC.setMotivoDesfazimento(3);
            return DENIED;
        }
        return SUCCESS;
    }
}

