/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiCtf;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;

public class MicQrCodeTransaction
extends MicAbstractBase {
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC ctfIn = Contexto.getContexto().getEntradaApiTefC();
        ctfIn.setQrcodeHash(Contexto.getContexto().getSaidaApiTefC().getQrcodeHash());
        ctfIn.setTimeoutCtf(Contexto.getContexto().getSaidaApiTefC().getTimeOutCTF());
        ctfIn.setModoEntrada(3);
        String op = Contexto.getContexto().getTipoOperacao();
        if (op.equals(OperationEnum.OP_CREDITO_GENERICO.getDescription()) || op.equals(OperationEnum.OP_CREDITO.getDescription())) {
            switch (Contexto.getContexto().getPlano()) {
                case ADMINISTRADORA: {
                    ctfIn.setOperacao(ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_ADMINISTRADORA.getValue());
                    break;
                }
                case LOJISTA: {
                    ctfIn.setOperacao(ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_LOJISTA.getValue());
                    break;
                }
                default: {
                    ctfIn.setOperacao(ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_AVISTA.getValue());
                    break;
                }
            }
        } else if (op.equals(OperationEnum.OP_CRED_PARC_SEM_JUROS.getDescription())) {
            ctfIn.setOperacao(ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_LOJISTA.getValue());
        } else if (op.equals(OperationEnum.OP_CRED_PARC_COM_JUROS.getDescription())) {
            ctfIn.setOperacao(ConstantesApiCtf.CONSULTA_QR_CODE_CREDITO_ADMINISTRADORA.getValue());
        } else if (op.equals(OperationEnum.OP_DEBITO_GENERICO.getDescription()) || op.equals(OperationEnum.OP_DEBITO.getDescription())) {
            ctfIn.setOperacao(ConstantesApiCtf.CONSULTA_QR_CODE_DEBITO.getValue());
        } else {
            this.logger.error("N\u00e3o foi poss\u00edvel setar a opera\u00e7\u00e3o [".concat(op).concat("]"));
            return ERROR;
        }
        SaidaApiTefC ctfOut = this.parent.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), ctfIn);
        Contexto.getContexto().setSaidaApiTefC(ctfOut);
        if (ctfOut.getRetorno() != 0) {
            return ERROR;
        }
        return SUCCESS;
    }
}

