/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.QrCodeGenerator;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiCtf;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractTrataRetornoPadrao;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;

public class MicPixPaymentRequest
extends MicAbstractTrataRetornoPadrao {
    @Override
    public String derivedExecute(Process processData) throws ExcecaoNaoLocal {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            return "FILLED";
        }
        try {
            this.setPinpadData(3);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel coletar todos os dados do pinpad: " + excecaoPerifericos.getMessage());
        }
        String result = super.genericExecute(processData);
        if (!"SUCCESS".equals(result)) {
            return result;
        }
        SaidaApiTefC ctfOutRequest = Contexto.getContexto().getSaidaApiTefC();
        if (ctfOutRequest != null) {
            if (ctfOutRequest.getPixTransactionId() == null) {
                this.logger.error("CTFServer nao informou o codigo de transacao pix.");
                return "ERROR";
            }
            Contexto.getContexto().setPixTransactionId(ctfOutRequest.getPixTransactionId());
            if (ctfOutRequest.getPixReceiverPSP() != null) {
                Contexto.getContexto().setPixReceiverPSP(ctfOutRequest.getPixReceiverPSP());
            } else {
                this.logger.error("CTFServer nao informou o recebedor psp pix.");
                return "ERROR";
            }
        }
        QrCodeGenerator qrCodeGenerator = processData.getqrCodeGenerator();
        String qrCode = Contexto.getContexto().getSaidaApiTefC().getQrcodeImageString();
        if (qrCode == null || qrCode.length() == 0) {
            this.logger.error("CTFServer nao informou o QRCode na solicitacao de pagamento pix.");
            return "ERROR";
        }
        byte[] imageByte = qrCodeGenerator.createQrCode(Contexto.getContexto().getSaidaApiTefC().getQrcodeImageString());
        this.saveQrCodeImage(imageByte);
        return "SUCCESS";
    }

    @Override
    protected String getCodigoTransacao(Process dados) {
        return ConstantesApiCtf.CONSULTA_PIX.getValue();
    }

    private void saveQrCodeImage(byte[] qrCodeImageBuffer) {
        try {
            ControladorPersistencia persistenceInstance = ControladorPersistencia.getInstance();
            IdentTerminal identTerminal = this.getIdentTerminal();
            persistenceInstance.saveQrCodeImage(identTerminal, qrCodeImageBuffer);
            this.logger.info("PNG do QR Code persistido com sucesso");
        }
        catch (ExcecaoApiAc excecaoApiAc) {
            this.logger.error("Erro ao salvar QR Code para Pix: " + excecaoApiAc.getMessage());
        }
    }
}

