/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.postef.EventoPOSTef;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.POSTefListener;
import com.csi.ctfclient.tools.devices.postef.model.RegistroPagamento;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;

public class MicPOSTef
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String POSTEF_LOCAL = "POSTEF_LOCAL";
    public static final String POSTEF_REMOTO = "POSTEF_REMOTO";
    public static final String USER_CANCEL = "USER_CANCEL";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        boolean posTEF = conf.getConfPOSTef() != null && conf.getConfPOSTef().isHabilitado();
        EntradaCTFClientCtrl entrada = Contexto.getContexto().getEntradaIntegracao();
        if (posTEF && this.isSuportaPOSMovel(entrada)) {
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            if (this.tryGetCardReader() != null) {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPPOSTES_TITLE), true);
                layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.CAPPOSTES_REMOTO), "1"));
                layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.CAPPOSTES_LOCAL), "2"));
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return USER_CANCEL;
                }
                switch (opcao) {
                    case 1: {
                        Contexto.getContexto().setPinpadPOSTefRemoto(true);
                        return this.processaTrasacaoRemota(dados, true);
                    }
                    case 2: {
                        return POSTEF_LOCAL;
                    }
                }
            } else {
                Contexto.getContexto().setPinpadPOSTefRemoto(true);
                return this.processaTrasacaoRemota(dados, false);
            }
        }
        return SUCCESS;
    }

    private String processaTrasacaoRemota(Process dados, boolean possuiPinpad) throws ExcecaoNaoLocal {
        final ControladorPerifericos perifericos = dados.getPerifericos();
        POSTef<?> posMovel = POSTef.getInstance();
        boolean posInicializado = posMovel.isInicializado();
        if (!posInicializado) {
            if (possuiPinpad) {
                String[] titulo = new String[]{"POS-MOVEL NAO CONECTADO", "CONTINUAR COM PAGAMENTO LOCAL?"};
                LayoutMenu layoutMenu = new LayoutMenu();
                layoutMenu.setTitulo(titulo);
                layoutMenu.addItem(new ItemMenu("SIM", "1"));
                layoutMenu.addItem(new ItemMenu("NAO", "2"));
                int opcao = perifericos.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return USER_CANCEL;
                }
                if (opcao == 1) {
                    return POSTEF_LOCAL;
                }
                this.logger.info("client-servico nao inicializado.");
                return USER_CANCEL;
            }
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("POS-MOVEL NAO INICIALIZADO OU CONECTADO"));
            perifericos.confirmaDado(layoutDisplay);
            this.logger.error("POS-MOVEL nao inicializado ou conectado");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
            return ERROR;
        }
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("RECUPERE O PAGAMENTO NO POS-MOVEL"));
        perifericos.imprimeDisplay(layoutDisplay);
        EntradaCTFClientCtrl entradaCTFClient = Contexto.getContexto().getEntradaIntegracao();
        RegistroPagamento registroPagamento = new RegistroPagamento();
        registroPagamento.setOperacao(entradaCTFClient.getOperacao());
        registroPagamento.setValorTransacao(entradaCTFClient.getValorTransacao());
        registroPagamento.setNumeroParcelas(entradaCTFClient.getNumeroParcelas());
        registroPagamento.setDataAbertura(entradaCTFClient.getDataAbertura());
        registroPagamento.setDocumento(entradaCTFClient.getDocumento());
        POSTefListener listener = new POSTefListener(){

            @Override
            public void onEvent(EventoPOSTef eventoPOSTef) {
                perifericos.eventoPOSTef(eventoPOSTef);
            }
        };
        posMovel.registrarPagamento(registroPagamento, listener);
        try {
            EventoDispositivoEntrada evt = perifericos.capturaPOSTef(layoutDisplay);
            if (evt instanceof EventoTeclado) {
                EventoTeclado eventoTeclado = (EventoTeclado)evt;
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    POSTef.getInstance().reset();
                    EventoPOSTef eventoPOSTef = new EventoPOSTef("PER_POSTEF", "");
                    eventoPOSTef.setCodigoRetorno(20);
                    eventoPOSTef.setCodigoErro("5317");
                    this.preparaRepostaPOSTef(eventoPOSTef, dados);
                    return USER_CANCEL;
                }
            } else if (evt instanceof EventoPOSTef) {
                EventoPOSTef eventoPOSTef = (EventoPOSTef)evt;
                this.preparaRepostaPOSTef(eventoPOSTef, dados);
            }
        }
        catch (ExcecaoNaoLocal e) {
            this.logger.error("Erro no processamento do evento POSTEF: " + e.getMessage());
            return ERROR;
        }
        return POSTEF_REMOTO;
    }

    private void preparaRepostaPOSTef(EventoPOSTef eventoPOSTef, Process dados) {
        EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
        entradaApiTefC.setNumeroTransacao(1);
        entradaApiTefC.setTimeoutCtf(15);
        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
        Contexto.getContexto().atualizaEntradaApiTefC(entradaApiTefC);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        if (eventoPOSTef != null) {
            String dataAutorizadora = null;
            String horaAutorizadora = null;
            saidaApiTefC.setRetorno(eventoPOSTef.getCodigoRetorno());
            if (eventoPOSTef.getCodigoTransacaoCTF() != null) {
                entradaApiTefC.setOperacao(eventoPOSTef.getCodigoTransacaoCTF());
            }
            if (eventoPOSTef.getValorTransacao() != null) {
                entradaApiTefC.setValorTransacao(eventoPOSTef.getValorTransacao());
                saidaApiTefC.setValorTransacao(eventoPOSTef.getValorTransacao());
            }
            eventoPOSTef.getNumeroParcelas();
            Contexto.getContexto().setCodigoAutorizadora(eventoPOSTef.getCodigoAutorizadora());
            if (eventoPOSTef.getCodigoRespAutorizadora() != null) {
                saidaApiTefC.setCodigoRespostaAutorizadora(eventoPOSTef.getCodigoRespAutorizadora());
            }
            eventoPOSTef.getDocumento();
            saidaApiTefC.setNsuCTF(eventoPOSTef.getNsuCTF());
            saidaApiTefC.setTaxaServico(new BigDecimal(eventoPOSTef.getTaxaServico()));
            saidaApiTefC.setNsuAutorizacao(eventoPOSTef.getNsuAutorizadora());
            saidaApiTefC.setCodigoAprovacao(eventoPOSTef.getCodigoAprovacao());
            if (eventoPOSTef.getMac() != null) {
                try {
                    saidaApiTefC.setMac(Integer.parseInt(eventoPOSTef.getMac()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            entradaApiTefC.setCnpj(eventoPOSTef.getCnpj());
            if (eventoPOSTef.getCodigoErro() != null) {
                try {
                    saidaApiTefC.setCodigoErro(Integer.parseInt(eventoPOSTef.getCodigoErro()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            eventoPOSTef.getDescricaoTransacao();
            if (eventoPOSTef.getCupomCliente() != null) {
                this.preparaCupom(eventoPOSTef.getCupomCliente(), "CUPOMCTF.1", entradaApiTefC.getNumeroTransacao());
            }
            if (eventoPOSTef.getCupomEstabelecimento() != null) {
                this.preparaCupom(eventoPOSTef.getCupomEstabelecimento(), "CUPOMCTF.2", entradaApiTefC.getNumeroTransacao());
            }
            if (eventoPOSTef.getCupomClienteReimpressao() != null) {
                this.preparaCupom(eventoPOSTef.getCupomClienteReimpressao(), "CUPOMCTF.5", entradaApiTefC.getNumeroTransacao());
            }
            if (eventoPOSTef.getCupomEstabelecimentoReimpressao() != null) {
                this.preparaCupom(eventoPOSTef.getCupomEstabelecimentoReimpressao(), "CUPOMCTF.6", entradaApiTefC.getNumeroTransacao());
            }
            Contexto.getContexto().setNomeAutorizadora(eventoPOSTef.getNomeAutorizadora());
            if (eventoPOSTef.getCodigoVan() != null) {
                try {
                    Contexto.getContexto().setCodigoVan(Integer.parseInt(eventoPOSTef.getCodigoVan()));
                }
                catch (Exception e) {
                    Contexto.getContexto().setCodigoVanAlfa(eventoPOSTef.getCodigoVan());
                }
            }
            Contexto.getContexto().setNomeVan(eventoPOSTef.getNomeVan());
            if (eventoPOSTef.getCodigoInstFinanceira() != null && eventoPOSTef.getCodigoInstFinanceira().trim().length() > 0) {
                Contexto.getContexto().setCodigoInstituicaoFinanceira(Integer.parseInt(eventoPOSTef.getCodigoInstFinanceira()));
            }
            if (eventoPOSTef.getNomeInstFinanceira() != null) {
                saidaApiTefC.setNomeInstituicaoFinanceira(eventoPOSTef.getNomeInstFinanceira());
                Contexto.getContexto().setNomeInstituicaoFinanceira(eventoPOSTef.getNomeInstFinanceira());
            }
            dataAutorizadora = eventoPOSTef.getDataTransacao();
            horaAutorizadora = eventoPOSTef.getHoraTransacao();
            if (eventoPOSTef.getLogomarca() != null) {
                saidaApiTefC.setLogomarca(eventoPOSTef.getLogomarca());
            }
            if (eventoPOSTef.getCpf() != null) {
                entradaApiTefC.setCpf(eventoPOSTef.getCpf());
            }
            if (eventoPOSTef.getCupomReduzido() != null) {
                this.preparaCupom(eventoPOSTef.getCupomReduzido(), "REDUZIDO.1", entradaApiTefC.getNumeroTransacao());
            }
            saidaApiTefC.setDisplayCTF(eventoPOSTef.getDisplay());
            saidaApiTefC.setNomeBandeiraProduto(eventoPOSTef.getNomeBandeira());
            saidaApiTefC.setNomeRedeAdquirente(eventoPOSTef.getNomeRedeAdquirente());
            if (dataAutorizadora != null && horaAutorizadora != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMYYYY");
                try {
                    saidaApiTefC.setDataAutorizadora(dateFormat.parse(dataAutorizadora + horaAutorizadora));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            entradaApiTefC.setCodigoTerminalOriginal(eventoPOSTef.getCodigoTerminal());
            Contexto.getContexto().setModoIntegracaoPOSTef(eventoPOSTef.getModeloIntegracao());
        }
    }

    private void preparaCupom(String cupom, String nome, int numTrans) {
        if (cupom == null) {
            return;
        }
        try {
            ControladorConfCTFClient controladorConf = ControladorConfCTFClient.getInstance();
            ConfCTFClient config = controladorConf.getConfig();
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            boolean multiEC = config.isMultiEC();
            IdentTerminal identTerminal = null;
            identTerminal = entradaIntegracao != null && multiEC ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            String path = identTerminal.getEstabelecimento().substring(1) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
            }
            cupom = cupom.replace('\\', '&');
            String[] linhas = cupom.split("&");
            cupom = path + nome + StringUtil.completaString(numTrans + "", 2, '0', 3);
            File fileCupom = new File(cupom);
            FileWriter fileWriter = new FileWriter(fileCupom);
            for (int i = 0; i < linhas.length; ++i) {
                fileWriter.write(linhas[i] + "\n");
            }
            fileWriter.close();
        }
        catch (Exception e) {
            this.logger.warn("Erro ao escrever o cupom: " + e.getMessage());
        }
    }

    private boolean isSuportaPOSMovel(EntradaCTFClientCtrl entrada) {
        if (entrada != null) {
            return entrada.getOperacao() == OperationEnum.OP_TEF_IP_VENDA_CARTAO.getKey().intValue();
        }
        return false;
    }
}

