/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.ProdutoBombaCombustivel;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicLiberaBombaCombustivel {
    public static String SUCCESS = "SUCCESS";
    public static String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        int quantidadeMaximaAbastecimentoFusion;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.ENVIO1F_TITLE));
        perifericos.imprimeDisplay(displayModel);
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        ControladorFusion fusion = ControladorFusion.getInstancia();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (saida.getTipoAbastecimento() == 2) {
            BigDecimal quantidadeMaximaAbastecimento = saida.getMaxLitrosAbastecimento();
            quantidadeMaximaAbastecimentoFusion = Integer.parseInt(quantidadeMaximaAbastecimento.movePointRight(2).intValue() + "0");
        } else if (saida.getTipoAbastecimento() == 1) {
            BigDecimal quantidadeMaximaAbastecimento = entrada.getValorTransacao().movePointRight(entrada.getBombaCombustivel().getCasasDecimais());
            quantidadeMaximaAbastecimentoFusion = entrada.getValorTransacao().movePointRight(entrada.getBombaCombustivel().getCasasDecimais()).intValue();
        } else {
            logger.error("Tipo de abastecimento n\u00e3o suportado: " + saida.getTipoAbastecimento());
            throw new IllegalArgumentException();
        }
        String hashCartao = CriptografiaUtil.gerarHash(entrada.getPAN(), "SHA-256");
        ProdutoConvenioCombustivel produtoConvenioCombustivel = null;
        StatusFusion statusFusion = null;
        try {
            ProdutoBombaCombustivel produtoFusion = new ProdutoBombaCombustivel(null);
            produtoConvenioCombustivel = entrada.getListProdutoConvenioCombustivel().get(0);
            produtoFusion.setId(ControladorFusion.converteCodigoProdutoFusion(produtoConvenioCombustivel.getCodigo()));
            statusFusion = fusion.preset(produtoFusion, entrada.getBombaCombustivel(), saida.getTipoAbastecimento(), quantidadeMaximaAbastecimentoFusion, hashCartao);
        }
        catch (Exception e) {
            logger.warn("Erro ao tentar criar produto fusion: " + e.getMessage());
        }
        if (statusFusion == null || statusFusion.getResultado() != 0) {
            if (statusFusion != null) {
                logger.error("Erro ao tentar efetuar o preset, c\u00f3digo: " + statusFusion.getResultado());
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        DecimalFormat formatValor = new DecimalFormat("#,##0.00");
        DecimalFormat formatLitros = new DecimalFormat("#,##0.00");
        displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("BOMBA LIBERADA"));
        String displayQuantidade = "";
        if (saida.getTipoAbastecimento() == 2) {
            displayQuantidade = formatLitros.format(saida.getMaxLitrosAbastecimento()) + " L";
        } else if (saida.getTipoAbastecimento() == 1) {
            displayQuantidade = "R$ " + formatValor.format(saida.getValorTransacao().doubleValue());
        }
        displayModel.addLinha(new Linha("BOMBA " + entrada.getBombaCombustivel().getId() + " - " + displayQuantidade));
        displayModel.addLinha(new Linha("PRODUTO " + produtoConvenioCombustivel.getCodigo() + " - " + produtoConvenioCombustivel.getDescricao()));
        perifericos.confirmaDado(displayModel);
        return SUCCESS;
    }
}

