/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;

public class MicLeituraValor {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String CONSULT = "CONSULT";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        String messageFirstLine;
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getValorTransacao() != null) {
            if (TransactionOperationRules.isCartaoPrePagoValorVariavel()) {
                Contexto.getContexto().setValorCartaoPrePagoVariavel(entradaApiTefC.getValorTransacao());
            }
            return FILLED;
        }
        if (TransactionOperationRules.isConsultaPrePagoVariavel()) {
            return CONSULT;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (!Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl()) {
                if (this.isProcessTransacoesGenericas(dados) && (OperationEnum.OP_OUTRAS_TRANSACOES.getKey().equals(Contexto.getContexto().getEntradaIntegracao().getOperacao()) || OperationEnum.OP_GENERICA.getKey().equals(Contexto.getContexto().getEntradaIntegracao().getOperacao()))) {
                    return NOT_REQUIRED;
                }
                if (this.valorObrigatorioAc(confCTFClient, OperationEnum.getEnumByKey(Contexto.getContexto().getEntradaIntegracao().getOperacao()))) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.VALOR_NAO_INFORMADO, "VALOR NAO INFORMADO"));
                    return ERROR_AC;
                }
            } else {
                Contexto.getContexto().getEntradaApiTefC().setValorTransacao(Contexto.getContexto().getEntradaIntegracao().getValorTransacao());
                return SUCESS;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String messageSecondLine = "";
        if (TransactionOperationRules.isCartaoPrePagoValorVariavel()) {
            SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
            messageFirstLine = inter.getMessage(MessageEnum.LEIVAL_TITLE);
            NumberFormat nf = NumberFormat.getCurrencyInstance();
            messageSecondLine = nf.format(saidaApiTefC.getValorMinimoPrePago()) + " ATE " + nf.format(saidaApiTefC.getValorMaximoPrePago());
        } else {
            messageFirstLine = confCTFClient.isIntegracaoAndroid() && Contexto.getContexto().getEntradaIntegracao().getOperacao() != OperationEnum.OP_CANCELAMENTO_GENERICO.getKey().intValue() ? "VALOR TRANSACAO" : inter.getMessage(MessageEnum.LEIVAL_TITLE);
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(messageFirstLine));
        if (BooleanUtils.negate(messageSecondLine.isEmpty()).booleanValue()) {
            displayModel.addLinha(new Linha(messageSecondLine));
        }
        if ("VOLTA".equals((eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_TRANSACAO, true, 3, false)).getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            return INVALID_NUMBER;
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            return INVALID_NUMBER;
        }
        valor = valor.movePointLeft(2);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (TransactionOperationRules.isCartaoPrePagoValorVariavel()) {
            if (valor.compareTo(saidaApiTefC.getValorMinimoPrePago()) < 0 || valor.compareTo(saidaApiTefC.getValorMaximoPrePago()) > 0) {
                return INVALID_NUMBER;
            }
            Contexto.getContexto().setValorCartaoPrePagoVariavel(valor);
        }
        Contexto.getContexto().getEntradaApiTefC().setValorTransacao(valor);
        return SUCESS;
    }

    private boolean isProcessTransacoesGenericas(Process dados) {
        return dados instanceof ProcessTransacoesGenericas;
    }

    private boolean valorObrigatorioAc(ConfCTFClient confCTFClient, OperationEnum operacao) {
        if (confCTFClient.isIntegracaoAndroid()) {
            return false;
        }
        switch (operacao) {
            case OP_CANCELAMENTO_GENERICO: 
            case OP_CANCELAMENTO_DIGITADO: 
            case OP_ESTORNO_PAG: 
            case OP_COMPRA_CREDITO_DIGITAL: 
            case OP_TROCO_SURPRESA: 
            case OP_TEF_IP_MENU_ADM: 
            case OP_DEPOSITO_COM_DOCUMENTO: 
            case OP_DEPOSITO_COM_CARTAO: 
            case OP_PAGAMENTO_FATURA_CARTAO: 
            case OP_CAPTURA_CREDITO: 
            case OP_ATIVACAO_CARTAO_PREPAGO: 
            case OP_DOTZ_ACUMULO: 
            case OP_DOTZ_RESGATE: 
            case OP_RESGATE_FACIL_EXTRATO: 
            case OP_RECARGA_CARTAO_PREPAGO_POSA: 
            case OP_RESGATE_CARTAO_PREPAGO_POSA: 
            case OP_RESGATE_BR_PREMMIA: 
            case OP_CONFIRMACAO_PRE_AUT_GENERICO: 
            case OP_PAGAMENTO_DINHEIRO_BR_PREMMIA: {
                return false;
            }
        }
        return true;
    }
}

