/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;

public class MicLeituraTaxaServico {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String TAX_EXCEED = "TAX_EXCEED";
    public static final String TAX_EXCEED_AC = "TAX_EXCEED_AC";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean habilitado = saidaApiTefC.isPedeTaxaServico();
        if (entradaApiTefC.getValorTaxaServico() != null) {
            return FILLED;
        }
        if (habilitado) {
            BigDecimal taxaServico = saidaApiTefC.getTaxaServico();
            if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorTaxaServicoCtrl()) {
                if (this.isValorValido(entradaApiTefC.getValorTransacao(), taxaServico, Contexto.getContexto().getEntradaIntegracao().getValorTaxaServico())) {
                    entradaApiTefC.setValorTaxaServico(Contexto.getContexto().getEntradaIntegracao().getValorTaxaServico());
                } else {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.LEITAXSER_EXCEDE_TAXA_SERVICO, this.inter.getMessage(MessageEnum.LEITAXSER_EXCEDE_TAXA_SERVICO)));
                }
            } else {
                ControladorPerifericos periferico = dados.getPerifericos();
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(this.inter.getMessage(MessageEnum.LEITAXSER_TAXA_SERVICO)));
                displayModel.addLinha(new Linha(this.inter.getMessage(MessageEnum.LEITAXSER_TAXA_SERVICO_VALOR)));
                EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_TAXA_SERVICO, false, 8, false);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    return USER_CANCEL;
                }
                if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                    int totalDigitos = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                    String valor = eventoTeclado.getStringLida().substring(totalDigitos);
                    if (valor.equals("")) {
                        valor = "000";
                    }
                    BigDecimal valorServico = new BigDecimal(valor);
                    valorServico = valorServico.movePointLeft(2);
                    if (!this.isValorValido(entradaApiTefC.getValorTransacao(), taxaServico, valorServico)) {
                        this.exibeMensagemExcedeTaxa(dados);
                        return TAX_EXCEED;
                    }
                    entradaApiTefC.setValorTaxaServico(valorServico);
                    return SUCESS;
                }
            }
        }
        return SUCESS;
    }

    private void exibeMensagemExcedeTaxa(Process dado) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(this.inter.getMessage(MessageEnum.LEITAXSER_EXCEDE_TAXA1)));
        displayModel.addLinha(new Linha(this.inter.getMessage(MessageEnum.LEITAXSER_EXCEDE_TAXA2)));
        perifericos.confirmaDado(displayModel);
    }

    public BigDecimal calcularValorMaximo(BigDecimal valorTransacao, BigDecimal taxa, BigDecimal valorServico) {
        if (taxa != null && taxa.doubleValue() > 0.0) {
            return valorTransacao.multiply(taxa).divide(new BigDecimal(100), 5);
        }
        return valorServico;
    }

    public boolean isValorValido(BigDecimal valorTransacao, BigDecimal taxa, BigDecimal valorServico) {
        return valorServico.compareTo(this.calcularValorMaximo(valorTransacao, taxa, valorServico)) != 1;
    }
}

