/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.ILeituraPin;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicLeituraPin {
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_RETRY = "USERCANCEL_RETRY";
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ILeituraPin dados) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento;
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        String titulo = dados.getTituloAguardaPin() != null && !dados.getTituloAguardaPin().equals("") ? dados.getTituloAguardaPin() : inter.getMessage(MessageEnum.LEIPIN_TITLE);
        if (titulo.indexOf("#") != 0) {
            String[] mensagens = titulo.split("#");
            displayModel = new LayoutDisplay();
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_senha);
            for (int i = 0; i < mensagens.length; ++i) {
                displayModel.addLinha(new Linha(mensagens[i]));
            }
        } else {
            displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(titulo));
        }
        boolean abort = false;
        do {
            if (!((evento = this.getEvent(displayModel, perifericos)) instanceof EventoTeclado)) continue;
            if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                abort = true;
                continue;
            }
            if (!"VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) || perifericos.exibeMenuCancelamento() != 1) continue;
            abort = true;
        } while (evento instanceof EventoTeclado && ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) || "ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora())) && !abort);
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                if (Contexto.getContexto().getEntradaIntegracao() != null) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CAPTURA_PIN, "ERRO NA CAPTURA DO PIN"));
                } else {
                    saidaApiTefC.setRetorno(20);
                }
                if (dados.isPossuiChaveContingencia() && eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_ERRPIN.getId().intValue()) {
                    this.logger.info("Erro ao utilizar a criptografia principal de senha, a conting\u00eancia ser\u00e1 utilizada");
                    return ERRO;
                }
                displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.LEIPIN_ERRO) + eventoPinEMV.getErroCodigo(), ControladorConfCTFClient.TIME_OUT_DELAY);
                perifericos.imprimeDisplay(displayModel);
                return ERRO;
            }
            if (Contexto.getContexto().getCartao() == Cartao.CHIP) {
                Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_APROVADA));
                Contexto.getContexto().setErrorCode(0);
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USERCANCEL;
            }
            switch (EMVResponseCode.getEnumByKey(eventoPinEMV.getErroCodigo())) {
                case PP_PROCESSING: 
                case PP_NOTIFY: {
                    this.logger.debug("");
                    Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                    if (Contexto.getContexto().getEntradaIntegracao() != null) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CAPTURA_PIN, "ERRO NA CAPTURA DO PIN"));
                    } else if (Contexto.getContexto().getSaidaApiTefC() != null) {
                        saidaApiTefC.setRetorno(20);
                    }
                    displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.LEIPIN_ERRO) + eventoPinEMV.getErroCodigo(), ControladorConfCTFClient.TIME_OUT_DELAY);
                    perifericos.imprimeDisplay(displayModel);
                    return ERRO;
                }
            }
            dados.setTeclaFuncaoPressionada(eventoPinEMV.getErroCodigo());
            PinInfo pinInfo = new PinInfo();
            pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
            pinInfo.setNumeroSerieChaveDUKPT(eventoPinEMV.getNumeroSerieChaveDUKPT());
            pinInfo.setStatusAprovacaoTransacao(eventoPinEMV.getStatusAprovacaoTransacao());
            pinInfo.setCapturadoVerificacaoOnline(true);
            pinInfo.setVerificadoOffline(eventoPinEMV.getPinVerificadoOffline());
            pinInfo.setRequerAssinatura(eventoPinEMV.getRequerAssinaturaPapel());
            Contexto.getContexto().setPinInfo(pinInfo);
            if (dados.isCapturaSenha()) {
                try {
                    boolean persistirDados = false;
                    ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                    DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                    if (Contexto.getContexto().getCartao() == Cartao.MAGNETICO) {
                        dadosEstatistica.addSenhaPinMagnetico();
                        persistirDados = true;
                    }
                    if (persistirDados) {
                        controladorEstatistica.persistirDados(dadosEstatistica);
                    }
                }
                catch (ExcecaoApiAc e) {
                    this.logger.error("Erro ao contabilizar estat\u00edstica em MicLeituraPin: " + e.getMessage());
                }
            }
            return SUCESS;
        }
        if (evento instanceof EventoTeclado) {
            return USERCANCEL;
        }
        return ERRO;
    }

    public EventoDispositivoEntrada getEvent(LayoutDisplay displayModel, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada event = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_LEITURA_PIN, false, new long[]{1L, 4L});
        if (event == null) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_DE_SISTEMA, "ERRO DE SISTEMA!"));
            this.logger.error("Erro no MicLeituraPin ao capturar o PIN. Atributo evento est\u00e1 nulo!");
        }
        return event;
    }
}

