/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.IleituraGoOnChip;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import java.util.Objects;

public class MicLeituraGoOnChip {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(IleituraGoOnChip dados) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento;
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        LayoutDisplay layoutDisplay = null;
        boolean abort = false;
        do {
            if (layoutDisplay != null) {
                perifericos.imprimeDisplay(layoutDisplay);
            }
            evento = perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_LEITURA_PIN, false, new long[]{1L, 4L});
            layoutDisplay = perifericos.getUltimoDisplay();
            if (!(evento instanceof EventoTeclado)) continue;
            if ("ABORT".equals(((EventoTeclado)evento).getTeclaFinalizadora())) {
                abort = true;
                continue;
            }
            if (!"VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) || perifericos.exibeMenuCancelamento(!config.isIntegracaoDll()) != 1) continue;
            abort = true;
        } while (evento instanceof EventoTeclado && ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) || "ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora())) && !abort);
        if (evento instanceof EventoTeclado) {
            Contexto.getContexto().setErrorCode(0);
            return USERCANCEL;
        }
        EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
        if (eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_CANCEL.getId().intValue()) {
            Contexto.getContexto().setErrorCode(0);
            return USERCANCEL;
        }
        if (eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_SAMERR.getId().intValue() || eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_DUMBCARD.getId().intValue() || eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_ERRCARD.getId().intValue() || eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_CARDAPPNAV.getId().intValue() || eventoPinEMV.getErroCodigo() == EMVResponseCode.PPC_ERRFALBACK.getId().intValue()) {
            if (saidaApiTefC.isPermiteFallbackGoonchip()) {
                logger.debug("Fallback habilitado na GoOnChip");
                Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
                PerifericoEventHandler.setActive(false);
                return ERROR_FALLBACK;
            }
            logger.info("Fallback na GoOnChip desabilitado");
        }
        if (eventoPinEMV.getErro()) {
            Contexto.getContexto().setErrorCode(eventoPinEMV.getErroCodigo());
            if (dados.isPossuiChaveContingencia() && eventoPinEMV.getErroCodigo() == EMVResponseCode.PP_ERRPIN.getId().intValue()) {
                logger.info("Erro ao utilizar a criptografia principal de senha, a conting\u00eancia ser\u00e1 utilizada");
                return ERRO;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CAPTURA_CHIP, "ERRO NA CAPTURA DO CHIP"));
            return ERRO;
        }
        Contexto.getContexto().setErrorCode(0);
        PinInfo pinInfo = new PinInfo();
        pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
        pinInfo.setDecisaoTomada(eventoPinEMV.getStatusAprovacaoTransacao());
        pinInfo.setRequerAssinatura(eventoPinEMV.getRequerAssinaturaPapel());
        pinInfo.setVerificadoOffline(eventoPinEMV.getPinVerificadoOffline());
        pinInfo.setNumApresentacoesInvalidasPinOff(eventoPinEMV.getNumApresentacoesInvalidasPinOff());
        pinInfo.setOfflineBloqueado(eventoPinEMV.getPinOfflineBloqueado());
        pinInfo.setNumeroSerieChaveDUKPT(eventoPinEMV.getNumeroSerieChaveDUKPT());
        pinInfo.setDadosCampo55(eventoPinEMV.getCampo55());
        pinInfo.setCapturadoVerificacaoOnline(eventoPinEMV.getPinCapturadoVerificacaoOnline());
        Contexto.getContexto().setPinInfo(pinInfo);
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setSenhaCriptoTapOnPhone(eventoPinEMV.getSenhaCriptoTapOnPhone());
        entrada.setKsnSenhaTapOnPhone(eventoPinEMV.getKsnSenhaTapOnPhone());
        try {
            ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
            DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
            if (pinInfo.isVerificadoOffline()) {
                dadosEstatistica.addSenhaOfflineChip();
            } else {
                dadosEstatistica.addSenhaOnlineChip();
            }
            for (int i = 0; i < pinInfo.getNumApresentacoesInvalidasPinOff(); ++i) {
                dadosEstatistica.addErroSenhaOfflineChip();
            }
            if (pinInfo.isOfflineBloqueado()) {
                dadosEstatistica.addCartoesBloqErroSenhaChip();
            }
            controladorEstatistica.persistirDados(dadosEstatistica);
        }
        catch (ExcecaoApiAc e) {
            logger.error("Erro ao contabilizar estat\u00edstica em MicLeituraPin: " + e.getMessage());
        }
        return SUCESS;
    }
}

