/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.model.constants.IEMVMessageErrorCode;
import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.CartaoSeguro;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MicLeituraCartao
extends MicAbstractBase {
    public static final String SUCESS_CARDTYPE = "SUCESS_CARDTYPE";
    public static final String SUCESS_CARDCHIP = "SUCESS_CARDCHIP";
    public static final String SUCESS_GETTRACKS = "SUCESS_GETTRACKS";
    public static final String SUCESS_CARDMAGNETIC = "SUCESS_CARDMAGNETIC";
    public static final String SUCESS_CARDCONTACTLESS_TARJA = "SUCESS_CARDCONTACTLESS_TARJA";
    public static final String SUCESS_CARDCONTACTLESS_EMV = "SUCESS_CARDCONTACTLESS_EMV";
    public static final String NECESSITA_CARGA_TABELA = "NECESSITA_CARGA_TABELA";
    public static final String ERRO = "ERRO";
    public static final String ERRO_CARDCHIP = "ERRO_CARDCHIP";
    public static final String ERRO_COMM = "ERRO_COMM";
    public static final String ERRO_ABORT = "ERRO_ABORT";
    public static final String ERRO_INVALID_NUMBER_TYPE = "ERRO_INVALID_NUMBER_TYPE";
    public static final String ERRO_INVALID_NUMBER_TYPE_AC = "ERRO_INVALID_NUMBER_TYPE_AC";
    public static final String ERRO_READCARD = "ERRO_READCARD";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String FILLED_CARDTYPE = "FILLED_CARDTYPE";
    public static final String FILLED_CARDCHIP = "FILLED_CARDCHIP";
    public static final String FILLED_CARDMAGNETIC = "FILLED_CARDMAGNETIC";
    public static final String FILLED_CARDCONTACTLESS_EMV = "FILLED_CARDCONTACTLESS_EMV";
    public static final String FILLED_CARDCONTACTLESS_TARJA = "FILLED_CARDCONTACTLESS_TARJA";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String REDIRECT_CREDITO_CELULAR = "REDIRECT_CREDITO_CELULAR";
    public static final String REDIRECT_IDENTIFICACAO_ASSOCIADO = "REDIRECT_IDENTIFICACAO_ASSOCIADO";

    public static String getNumero(EventoLeitorCartao eventoLeitor) {
        if (eventoLeitor.getNumeroExternoCartao() != null && !eventoLeitor.getNumeroExternoCartao().trim().isEmpty()) {
            return eventoLeitor.getNumeroExternoCartao();
        }
        if (eventoLeitor.getPAN() != null && !eventoLeitor.getPAN().isEmpty()) {
            return eventoLeitor.getPAN();
        }
        int i = 0;
        StringBuilder buffer = new StringBuilder();
        if (!eventoLeitor.getTrilha1().trim().isEmpty()) {
            if (!Character.isDigit(eventoLeitor.getTrilha1().charAt(0))) {
                ++i;
            }
            while (i < eventoLeitor.getTrilha1().length()) {
                if (Character.isDigit(eventoLeitor.getTrilha1().charAt(i))) {
                    buffer.append(eventoLeitor.getTrilha1().charAt(i));
                } else if (!Character.isSpaceChar(eventoLeitor.getTrilha1().charAt(i))) break;
                ++i;
            }
        }
        i = 0;
        if (buffer.toString().trim().isEmpty() && !eventoLeitor.getTrilha2().trim().isEmpty()) {
            if (!Character.isDigit(eventoLeitor.getTrilha2().charAt(0))) {
                ++i;
            }
            while (i < eventoLeitor.getTrilha2().length()) {
                if (Character.isDigit(eventoLeitor.getTrilha2().charAt(i))) {
                    buffer.append(eventoLeitor.getTrilha2().charAt(i));
                } else if (!Character.isSpaceChar(eventoLeitor.getTrilha2().charAt(i))) break;
                ++i;
            }
        }
        return buffer.toString();
    }

    public static String getNomePortador(EventoLeitorCartao evento) {
        if (evento.getNomePortadorCartao() == null || evento.getNomePortadorCartao().trim().isEmpty()) {
            int posInicio = evento.getTrilha1().indexOf(94) + 1;
            if (posInicio == 0) {
                return "";
            }
            int posFim = evento.getTrilha1().indexOf(94, posInicio);
            if (posFim == -1) {
                posFim = evento.getTrilha1().length();
            }
            return evento.getTrilha1().substring(posInicio, posFim);
        }
        return evento.getNomePortadorCartao();
    }

    @Override
    public String derivedExecute(Process dado) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento;
        boolean numeroPreenchido;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (Contexto.getContexto().getCartao() != null) {
            if (Contexto.getContexto().getCartao() == Cartao.CHIP) {
                return FILLED_CARDCHIP;
            }
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return FILLED_CARDTYPE;
            }
            if (Contexto.getContexto().getCartao() == Cartao.MAGNETICO) {
                return FILLED_CARDMAGNETIC;
            }
            if (Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) {
                return FILLED_CARDCONTACTLESS_EMV;
            }
            if (Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_TARJA) {
                return FILLED_CARDCONTACTLESS_TARJA;
            }
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ILeitorCartaoHandler leitorCartao = this.tryGetCardReader();
        if (entradaIntegracao != null && entradaIntegracao.isNumeroCartaoCtrl()) {
            if (null == entradaIntegracao.getNumeroCartao()) {
                this.logger.error("O n\u00famero do cart\u00e3o n\u00e3o foi informado corretamente");
                return ERRO_INVALID_NUMBER_TYPE_AC;
            }
            try {
                entrada.setPAN(entradaIntegracao.getNumeroCartao());
                entrada.setInfo(entradaIntegracao.getNumeroCartao());
                Contexto.getContexto().setCartao(Cartao.DIGITADO);
                entrada.setModoEntrada(Cartao.DIGITADO.getModoEntrada().getId());
                if (!KeyFactory.isChaveLocal()) {
                    CartaoSeguro cartaoSeguro = new CartaoSeguro();
                    entrada.setCartaoSeguro(cartaoSeguro);
                }
                Contexto.getContexto().setErrorCode(-1);
                return SUCESS_CARDTYPE;
            }
            catch (IllegalArgumentException e) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.LEICAR_CARTAO_INVALIDO, inter.getMessage(MessageEnum.MST_ERRO_READ_CARD1)));
                return ERRO_INVALID_NUMBER_TYPE_AC;
            }
        }
        if (entradaIntegracao != null && entradaIntegracao.isMultiTerminal()) {
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.LEICAR_CARTAO_INVALIDO, inter.getMessage(MessageEnum.LEICAR_CARTAO_INVALIDO)));
            return ERRO_INVALID_NUMBER_TYPE_AC;
        }
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        boolean menuCreditoCelularHabilitado = (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO.getDescription()) || Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_CREDITO_GENERICO.getDescription())) && config.isCreditoCelularHabilitado();
        boolean deliveryInternet = entrada.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE || entrada.getOrigemTransacao() == OrigemTransacaoEnum.INTERNET;
        boolean typedOperation = TransactionOperationRules.isTypedOperation();
        String msgDisplay = "";
        LayoutDisplay displayModel = this.getLayoutDisplay(perifericos, saida, leitorCartao, msgDisplay, deliveryInternet, typedOperation, inter, config);
        boolean abort = false;
        do {
            long[] perifericosHabilitados;
            numeroPreenchido = true;
            ConstantesApiAc.TipoCampo tipoCampo = ConstantesApiAc.CAP_CARTAO_DIGITADO;
            if (typedOperation) {
                perifericosHabilitados = new long[]{1L};
            } else if (TransactionOperationRules.isCartaoQualidade()) {
                perifericosHabilitados = new long[]{1L, 32L};
            } else {
                perifericosHabilitados = new long[]{1L, 8L};
                if (entradaIntegracao != null && entradaIntegracao.isDesabilitaDigitacaoCtrl()) {
                    if (entradaIntegracao.isDesabilitaDigitacao()) {
                        tipoCampo = ConstantesApiAc.CAP_CARTAO;
                    }
                } else if (config.isDesabilitadaDigitacao()) {
                    tipoCampo = ConstantesApiAc.CAP_CARTAO;
                }
            }
            this.logger.trace("Perifericos Habilitados: " + Arrays.toString(perifericosHabilitados));
            evento = perifericos.capturaDado(displayModel, tipoCampo, false, perifericosHabilitados);
            if (!(evento instanceof EventoTeclado)) continue;
            String teclaFinalizadora = ((EventoTeclado)evento).getTeclaFinalizadora();
            if ("ENTRA".equals(teclaFinalizadora)) {
                EventoTeclado eventoTeclado = (EventoTeclado)evento;
                String numeroDigitado = eventoTeclado.getStringLida().substring(eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados());
                if (TransactionOperationRules.isCartaoQualidade()) {
                    Contexto.getContexto().getEntradaApiTefC().setIdentificadorCartaoQualidade(numeroDigitado);
                }
                if (!numeroDigitado.isEmpty()) continue;
                numeroPreenchido = false;
                continue;
            }
            if ("ABORT".equals(teclaFinalizadora)) {
                abort = true;
                continue;
            }
            if (!"VOLTA".equals(teclaFinalizadora)) continue;
            if (perifericos.exibeMenuCancelamento(!config.isIntegracaoDll()) == 1) {
                abort = true;
                continue;
            }
            numeroPreenchido = false;
        } while (!numeroPreenchido || evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.LeitorCartaoHandler") && !abort && !menuCreditoCelularHabilitado);
        if (evento instanceof EventoLeitorCartao) {
            try {
                PinEMV pin = perifericos.getPinpad();
                pin.displayWaitMessage();
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                this.logger.warn("Nao foi possivel exibir display de espera no pinpad: " + excecaoPerifericos.getMessage());
            }
            EventoLeitorCartao eventoLeitorCartao = (EventoLeitorCartao)evento;
            if (eventoLeitorCartao.getErroCodigo() == EMVResponseCode.PP_CANCEL.getId().intValue()) {
                Contexto.getContexto().setErrorCode(-1);
                return USERCANCEL;
            }
            if (eventoLeitorCartao.getCartaoComErro()) {
                this.logger.info("cartao com erro: " + eventoLeitorCartao.getErroCodigo());
                entrada.setRetornoBibliotecaCompartilhada(eventoLeitorCartao.getErroCodigo());
                switch (EMVResponseCode.getEnumByKey(eventoLeitorCartao.getErroCodigo())) {
                    case PP_CTLSEXTCVM: {
                        Contexto.getContexto().setErrorCode(eventoLeitorCartao.getErroCodigo());
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        return ERRO_CARDCHIP;
                    }
                    case PP_DENIEDBYCARD: 
                    case PP_CTLSSCOMMERR: 
                    case PP_SAMERR: 
                    case PP_NOAPPLIC: 
                    case PP_ERROR_23: 
                    case PP_ERROR_24: 
                    case PP_ERROR_25: 
                    case PP_ERROR_26: 
                    case PP_ERROR_27: 
                    case PP_ERROR_28: 
                    case PP_ERROR_29: {
                        if (Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_CTLSSCOMMERR.getId().intValue()) {
                            this.logger.info("Retornado o erro PP_CTLSSCOMMERR duas vezes seguidas, desabilitando o contactless na pr\u00f3xima leitura");
                            Contexto.getContexto().setDesabilitaContactlessProximaLeitura(true);
                        }
                        Contexto.getContexto().setErrorCode(eventoLeitorCartao.getErroCodigo());
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        return this.getErro(config, eventoLeitorCartao, ERRO_CARDCHIP);
                    }
                    case PP_CTLSSINVALIDAT: 
                    case PP_CTLSSPROBLEMS: 
                    case PP_CTLSSAPPNAV: 
                    case PP_CTLSSAPPNAUT: 
                    case PP_CTLSIFCHG: {
                        Contexto.getContexto().setDesabilitaContactlessProximaLeitura(true);
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        Contexto.getContexto().setErrorCode(eventoLeitorCartao.getErroCodigo());
                        return this.getErro(config, eventoLeitorCartao, ERRO);
                    }
                    case PP_ERROCARTAOABORT: {
                        Contexto.getContexto().setErrorCode(EMVResponseCode.PP_CARDPROBLEMS.getId());
                        Contexto.getContexto().setStatusLeituraCartao(1);
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.LEICAR_CARTAO_INVALIDO, inter.getMessage(MessageEnum.MST_ERRO_READ_CARD1)));
                        return ERRO_ABORT;
                    }
                    case PP_TABEXP: {
                        if (config.isIntegracaoAndroid()) {
                            CMOSPinPad.getInstance().refazerCargaTabelas(0);
                        } else {
                            this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Carga de tabelas PP_TABEXP");
                            CMOSPinPad.getInstance().solicitarCargaTabelas(0);
                        }
                        return NECESSITA_CARGA_TABELA;
                    }
                    case PP_MCDATAERR: {
                        this.exibeMensagemDuasLinhas(perifericos, inter.getMessage(MessageEnum.MST_ERRO_READ_CARD1), inter.getMessage(MessageEnum.MST_ERRO_READ_CARD2));
                        Contexto.getContexto().setErrorCode(-1);
                        if (Contexto.getContexto().getStatusLeituraCartao() == 1) {
                            Contexto.getContexto().setStatusLeituraCartao(3);
                        }
                        if (entradaIntegracao != null && entradaIntegracao.getOperacao() == OperationEnum.OP_IDENTIFICACAO_CARTAO_ASSOCIADO.getKey().intValue()) {
                            this.logger.info("Leitura de cart\u00e3o de uma Identifica\u00e7\u00e3o de associado associado com erro");
                            return REDIRECT_IDENTIFICACAO_ASSOCIADO;
                        }
                        return ERRO_READCARD;
                    }
                    case PP_COMMERR: 
                    case PP_NOTOPEN: 
                    case PP_RSPERR: {
                        this.exibeMensagemDuasLinhas(perifericos, inter.getMessage(MessageEnum.MST_ERRO_COMM1), "");
                        Contexto.getContexto().setErrorCode(-1);
                        return ERRO_COMM;
                    }
                }
                Contexto.getContexto().setErrorCode(eventoLeitorCartao.getErroCodigo());
                this.logger.debug("saida default");
                return ERRO;
            }
            if (this.validaCartao(perifericos, eventoLeitorCartao, inter)) {
                Contexto.getContexto().setStatusLeituraCartao(0);
                this.logger.debug("saida verifica cart\u00e3o lido");
                try {
                    return this.verificaCartaoLido(perifericos, eventoLeitorCartao, inter);
                }
                catch (ExcecaoPerifericos excecaoPerifericos) {
                    this.logger.error("Erro ao definir o tipo de leitura das trilhas do cartao: " + excecaoPerifericos.getMessage());
                    return ERRO;
                }
            }
        } else if (evento instanceof EventoTeclado) {
            EventoTeclado eventoTeclado = (EventoTeclado)evento;
            String teclaFinalizadora = eventoTeclado.getTeclaFinalizadora();
            String stringLida = eventoTeclado.getStringLida();
            if ("VOLTA".equals(teclaFinalizadora)) {
                if (menuCreditoCelularHabilitado) {
                    this.logger.info("Cr\u00e9dito com celular habilitado, redirecionando para fluxo de cr\u00e9dito com celular");
                    Contexto.getContexto().setSubfluxoCreditoCelular(true);
                    return REDIRECT_CREDITO_CELULAR;
                }
                Contexto.getContexto().setErrorCode(-1);
                return USERCANCEL;
            }
            if ("ABORT".equals(teclaFinalizadora)) {
                Contexto.getContexto().setErrorCode(-1);
                return USERCANCEL;
            }
            String numeroDigitado = stringLida.substring(stringLida.length() - eventoTeclado.getNumCaracteresDigitados());
            try {
                if (Contexto.getContexto().getStatusLeituraCartao() == 3) {
                    entrada.setFallbackDigitado(true);
                }
                if (this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numeroDigitado)) {
                    entrada.setPAN(numeroDigitado);
                    entrada.setInfo(numeroDigitado);
                    Contexto.getContexto().setCartao(Cartao.DIGITADO);
                    entrada.setModoEntrada(Cartao.DIGITADO.getModoEntrada().getId());
                    if (!KeyFactory.isChaveLocal()) {
                        CartaoSeguro cartaoSeguro = new CartaoSeguro();
                        entrada.setCartaoSeguro(cartaoSeguro);
                    }
                    Contexto.getContexto().setErrorCode(-1);
                    return SUCESS_CARDTYPE;
                }
                this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_5399, inter.getMessage(MessageEnum.MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            catch (IllegalArgumentException e) {
                this.exibeMensagem(perifericos, inter);
                return ERRO_INVALID_NUMBER_TYPE;
            }
        }
        this.logger.debug("saida cart\u00e3o n\u00e3o emv , teclado");
        return ERRO;
    }

    private String getErro(ConfCTFClient config, EventoLeitorCartao eventoLeitorCartao, String retornoErroPadrao) {
        if (config.isIntegracaoTapOnPhone()) {
            this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_EMV, IEMVMessageErrorCode.getEnumByKey(eventoLeitorCartao.getErroCodigo(), config.getTipoIntegracaoEnum()).getMsgDisplay());
            return ERRO_ABORT;
        }
        return retornoErroPadrao;
    }

    private LayoutDisplay getLayoutDisplay(ControladorPerifericos perifericos, SaidaApiTefC saida, ILeitorCartaoHandler leitorCartao, String msgDisplay, boolean deliveryInternet, boolean typedOperation, InternacionalizacaoUtil inter, ConfCTFClient confCTFClient) {
        LayoutDisplay displayModel = null;
        if (!deliveryInternet && !typedOperation && leitorCartao != null) {
            if ((leitorCartao.getSolicitaCargaTabelas() == LeitorCartao.CARGA_TABELA_OK || leitorCartao.getSolicitaCargaTabelas() == LeitorCartao.ERRO_SOLICITA_CARGA_TABELA) && msgDisplay.trim().isEmpty()) {
                if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_DEBITO.getDescription())) {
                    displayModel = this.getDisplayLeituraCartao(perifericos, confCTFClient);
                } else if (Contexto.getContexto().getStatusLeituraCartao() == 1) {
                    displayModel = this.getDisplayLeituraCartao(perifericos, confCTFClient);
                } else if (this.validaFallBack()) {
                    if (leitorCartao.getSolicitaCargaTabelas() == LeitorCartao.CARGA_TABELA_OK && msgDisplay.trim().isEmpty()) {
                        displayModel = new LayoutDisplay();
                        for (int i = 0; i < saida.getDisplayCTF().length; ++i) {
                            String[] mensagem;
                            for (String s : mensagem = saida.getDisplayCTF()[i].split("#")) {
                                displayModel.addLinha(new Linha(s));
                            }
                        }
                    }
                } else {
                    displayModel = this.getDisplayLeituraCartao(perifericos, confCTFClient);
                }
            }
        } else {
            displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.LEICAR_TITLE_TYPED));
        }
        return displayModel;
    }

    private boolean validaCartao(ControladorPerifericos perifericos, EventoLeitorCartao eventoLeitor, InternacionalizacaoUtil inter) throws ExcecaoNaoLocal {
        if (StringUtils.isNotBlank(eventoLeitor.getIdentificadorCartaoQualidade()) || StringUtils.isNotBlank(eventoLeitor.getTrilha1()) || StringUtils.isNotBlank(eventoLeitor.getTrilha2()) || StringUtils.isNotBlank(eventoLeitor.getTrilha2CriptoTapOnPhone())) {
            return true;
        }
        this.logger.info("As Trilhas estao nulas ou vazias. Exibindo mensagem.");
        this.exibeMensagem(perifericos, inter);
        return false;
    }

    private String verificaCartaoLido(ControladorPerifericos perifericos, EventoLeitorCartao eventoLeitor, InternacionalizacaoUtil inter) throws ExcecaoPerifericos {
        String retorno = ERRO;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        String regexNomePortador = "[^(a-zA-Z0-9\\-\\/\\!\\\"\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\.\\:\\;\\<\\=\\>\\?\\@\\ )]";
        String numero = MicLeituraCartao.getNumero(eventoLeitor);
        switch (eventoLeitor.getTipoCartao()) {
            case 421: {
                if (Contexto.getContexto().getErrorCode() > 0) {
                    Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                }
                Contexto.getContexto().setErrorCode(-1);
                if (eventoLeitor.getIdentificadorCartaoQualidade() != null) {
                    Contexto.getContexto().setCartao(Cartao.CHIP);
                    entrada.setModoEntrada(Cartao.CHIP.getModoEntrada().getId());
                    entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                    entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                    entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                    entrada.setWFlags(eventoLeitor.getFlags());
                    entrada.setIdentificadorCartaoQualidade(eventoLeitor.getIdentificadorCartaoQualidade());
                }
                retorno = SUCESS_CARDCHIP;
                break;
            }
            case 0: {
                if (Contexto.getContexto().getErrorCode() > 0) {
                    Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                }
                Contexto.getContexto().setErrorCode(-1);
                if (this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numero)) {
                    Contexto.getContexto().setCartao(Cartao.MAGNETICO);
                    entrada.setModoEntrada(Cartao.MAGNETICO.getModoEntrada().getId());
                    if (eventoLeitor.getNomePortadorCartao() != null && !eventoLeitor.getNomePortadorCartao().isEmpty()) {
                        entrada.setNomeCliente(MicLeituraCartao.getNomePortador(eventoLeitor).replaceAll(regexNomePortador, ""));
                    }
                    entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                    entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                    entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                    entrada.setWFlags(eventoLeitor.getFlags());
                    entrada.setDadosRedeAdquirente(eventoLeitor.getDadosRestantes());
                    if (KeyFactory.isChaveLocal()) {
                        entrada.setPAN(numero);
                        entrada.setPANCripto(eventoLeitor.getPANCripto());
                        if (eventoLeitor.getTrilha1() != null) {
                            entrada.setTrilha1(eventoLeitor.getTrilha1());
                        }
                        if (eventoLeitor.getTrilha2() != null) {
                            entrada.setInfo(eventoLeitor.getTrilha2());
                        }
                    } else {
                        CartaoSeguro cartaoSeguro = new CartaoSeguro();
                        cartaoSeguro.setPan(eventoLeitor.getPAN());
                        cartaoSeguro.setTrilha1(eventoLeitor.getTrilha1());
                        cartaoSeguro.setTrilha2(eventoLeitor.getTrilha2());
                        entrada.setCartaoSeguro(cartaoSeguro);
                    }
                    if (((BibliotecaPinpad)perifericos.getPinpad()).isPinpadAbecs()) {
                        retorno = SUCESS_GETTRACKS;
                        break;
                    }
                    retorno = SUCESS_CARDMAGNETIC;
                    break;
                }
                this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_5399, inter.getMessage(MessageEnum.MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            case 3: 
            case 4: {
                entrada.setTipoDispositivoCartao(eventoLeitor.getTipoDispositivoCartao());
                if (this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numero)) {
                    if (eventoLeitor.getNomePortadorCartao() != null && !eventoLeitor.getNomePortadorCartao().isEmpty()) {
                        entrada.setNomeCliente(eventoLeitor.getNomePortadorCartao().replaceAll(regexNomePortador, ""));
                    }
                    Contexto.getContexto().setCartao(Cartao.CHIP);
                    entrada.setModoEntrada(Cartao.CHIP.getModoEntrada().getId());
                    entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                    entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                    entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                    entrada.setWFlags(eventoLeitor.getFlags());
                    if (KeyFactory.isChaveLocal()) {
                        if (eventoLeitor.getTrilha1() != null) {
                            entrada.setTrilha1(eventoLeitor.getTrilha1());
                        }
                        if (eventoLeitor.getTrilha2() != null) {
                            entrada.setInfo(eventoLeitor.getTrilha2());
                        }
                        entrada.setPAN(numero);
                        entrada.setPANCripto(eventoLeitor.getPANCripto());
                        entrada.setNumeroAplicacao(numero);
                    } else {
                        CartaoSeguro cartaoSeguro = new CartaoSeguro();
                        cartaoSeguro.setPan(eventoLeitor.getPAN());
                        cartaoSeguro.setTrilha1(eventoLeitor.getTrilha1());
                        cartaoSeguro.setTrilha2(eventoLeitor.getTrilha2());
                        cartaoSeguro.setNumeroAplicacao(numero);
                        entrada.setCartaoSeguro(cartaoSeguro);
                    }
                    entrada.setIndiceAid(eventoLeitor.getIndiceRegistro());
                    entrada.setAidSelecionado(eventoLeitor.getSelectedAID());
                    entrada.setCodigoRedeAdquirenteChip(eventoLeitor.getTipoRedeAdquirente());
                    entrada.setCardSequenceNumber(eventoLeitor.getPANSequenceNumber());
                    entrada.setTipoAplicacaoChip(eventoLeitor.getTipoAplicacaoSelecionada());
                    entrada.setApplicationExpirationDate(eventoLeitor.getAppExpirationDate());
                    entrada.setApplicationLabel(eventoLeitor.getAppLabel());
                    entrada.setDadosRedeAdquirente(eventoLeitor.getDadosRestantes());
                    if (Contexto.getContexto().getErrorCode() > 0) {
                        Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                    }
                    Contexto.getContexto().setErrorCode(0);
                    if (((BibliotecaPinpad)perifericos.getPinpad()).isPinpadAbecs()) {
                        retorno = SUCESS_GETTRACKS;
                        break;
                    }
                    retorno = SUCESS_CARDCHIP;
                    break;
                }
                this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_5399, inter.getMessage(MessageEnum.MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            case 5: 
            case 6: {
                entrada.setTipoDispositivoCartao(eventoLeitor.getTipoDispositivoCartao());
                entrada.setKsnDadosTapOnPhone(eventoLeitor.getKsnDadosTapOnPhone());
                entrada.setTrilha2CriptoTapOnPhone(eventoLeitor.getTrilha2CriptoTapOnPhone());
                entrada.setPanCriptoTapOnPhone(eventoLeitor.getPanCriptoTapOnPhone());
                entrada.setDataVencCriptoTapOnPhone(eventoLeitor.getDataVencCriptoTapOnPhone());
                if (!this.validaCartaoAnterior(Contexto.getContexto().getEntradaApiTefC().getPAN(), numero)) break;
                if (eventoLeitor.getNomePortadorCartao() != null && !eventoLeitor.getNomePortadorCartao().isEmpty()) {
                    entrada.setNomeCliente(eventoLeitor.getNomePortadorCartao().replaceAll(regexNomePortador, ""));
                }
                if (eventoLeitor.getTipoCartao() == 5) {
                    Contexto.getContexto().setCartao(Cartao.CONTACTLESS_TARJA);
                    entrada.setModoEntrada(Cartao.CONTACTLESS_TARJA.getModoEntrada().getId());
                } else if (eventoLeitor.getTipoCartao() == 6) {
                    Contexto.getContexto().setCartao(Cartao.CONTACTLESS_EMV);
                    entrada.setModoEntrada(Cartao.CONTACTLESS_EMV.getModoEntrada().getId());
                    entrada.setIndiceAid(eventoLeitor.getIndiceRegistro());
                    entrada.setAidSelecionado(eventoLeitor.getSelectedAID());
                    entrada.setCodigoRedeAdquirenteChip(eventoLeitor.getTipoRedeAdquirente());
                    entrada.setCardSequenceNumber(eventoLeitor.getPANSequenceNumber());
                    entrada.setTipoAplicacaoChip(eventoLeitor.getTipoAplicacaoSelecionada());
                    entrada.setApplicationExpirationDate(eventoLeitor.getAppExpirationDate());
                    entrada.setApplicationLabel(eventoLeitor.getAppLabel());
                    entrada.setDadosRedeAdquirente(eventoLeitor.getDadosRestantes());
                }
                entrada.setStatusChip(eventoLeitor.getStatusUltLeitura());
                entrada.setTipoCartao(eventoLeitor.getTipoCartao());
                entrada.setIssuerCountryCode(eventoLeitor.getIssuerCountryCode());
                entrada.setWFlags(eventoLeitor.getFlags());
                if (KeyFactory.isChaveLocal()) {
                    if (eventoLeitor.getTrilha1() != null) {
                        entrada.setTrilha1(eventoLeitor.getTrilha1());
                    }
                    if (eventoLeitor.getTrilha2() != null) {
                        entrada.setInfo(eventoLeitor.getTrilha2());
                    }
                    entrada.setPAN(numero);
                    entrada.setPANCripto(eventoLeitor.getPANCripto());
                    entrada.setNumeroAplicacao(numero);
                } else {
                    CartaoSeguro cartaoSeguro = new CartaoSeguro();
                    cartaoSeguro.setPan(eventoLeitor.getPAN());
                    cartaoSeguro.setTrilha1(eventoLeitor.getTrilha1());
                    cartaoSeguro.setTrilha2(eventoLeitor.getTrilha2());
                    cartaoSeguro.setNumeroAplicacao(numero);
                    entrada.setCartaoSeguro(cartaoSeguro);
                }
                if (Contexto.getContexto().getErrorCode() > 0) {
                    Contexto.getContexto().getEntradaApiTefC().setRetornoBibliotecaCompartilhada(Contexto.getContexto().getErrorCode());
                }
                Contexto.getContexto().setErrorCode(0);
                if (((BibliotecaPinpad)perifericos.getPinpad()).isPinpadAbecs()) {
                    retorno = SUCESS_GETTRACKS;
                    break;
                }
                if (eventoLeitor.getTipoCartao() == 5) {
                    retorno = SUCESS_CARDCONTACTLESS_TARJA;
                    break;
                }
                if (eventoLeitor.getTipoCartao() != 6) break;
                retorno = SUCESS_CARDCONTACTLESS_EMV;
            }
        }
        return retorno;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, InternacionalizacaoUtil inter) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.MST_ERRO_VALID_CARD));
        displayModel.setImagem(LayoutDisplay.imagens.erro_pinpad);
        perifericos.confirmaDado(displayModel);
    }

    private void exibeMensagemDuasLinhas(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setImagem(LayoutDisplay.imagens.erro_pinpad);
        displayModel.setDelay(ControladorConfCTFClient.TIME_OUT_DELAY);
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        perifericos.imprimeDisplay(displayModel);
    }

    private boolean validaFallBack() {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && saidaApiTefC.getCodigoRespostaAutorizadora() != null) {
            String operacao = saidaApiTefC.getCodigoRespostaAutorizadora();
            return operacao.equals("F3") || operacao.equals("0F3");
        }
        return false;
    }

    private boolean validaCartaoAnterior(String pan, String panLido) {
        if (pan != null) {
            return pan.equals(panLido);
        }
        return true;
    }

    private LayoutDisplay getDisplayLeituraCartao(ControladorPerifericos perifericos, ConfCTFClient config) {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LeitorCartao leitorCartao = null;
        ILeitorCartaoHandler leitorCartaoDriver = null;
        try {
            leitorCartaoDriver = perifericos.getLeitorCartao();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel carregar o leitor de cartoes: " + excecaoPerifericos.getMessage());
        }
        if (leitorCartaoDriver != null) {
            leitorCartao = leitorCartaoDriver.getLeitorCartao();
        }
        if (leitorCartao != null && leitorCartao.isHabilitaContactless()) {
            if (config.isIntegracaoTapOnPhone()) {
                displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS_TOP1));
                if (!inter.getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS_TOP2).isEmpty()) {
                    displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS_TOP2)));
                }
            } else {
                displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS1));
                if (!inter.getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS2).isEmpty()) {
                    displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.LEICAR_TITLE_CONTACTLESS2)));
                }
            }
        } else {
            displayModel = TransactionOperationRules.isCartaoQualidade() ? new LayoutDisplay(inter.getMessage(MessageEnum.LEICAR_TITLE2)) : new LayoutDisplay(inter.getMessage(MessageEnum.LEICAR_TITLE));
        }
        displayModel.setImagem(LayoutDisplay.imagens.inserir_cartao);
        return displayModel;
    }
}

