/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.action.ProcessReimpressaoComprovante;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.ExibeDialog;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicImpressaoComprovantes {
    public static final String SUCESS_IMPRIME = "SUCESS_IMPRIME";
    public static final String SUCESS_DESFAZ = "SUCESS_DESFAZ";
    public static final String SUCESS_CONFIRMACAO = "SUCESS_CONFIRMACAO";
    public static final String SUCESS_SEM_CUPOM = "SUCESS_SEM_CUPOM";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO = "ERRO";
    private final String SEPARATOR = "--------------------------------------";

    public String execute(Process dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!Contexto.getContexto().getSaidaApiTefC().isCupomPresente()) {
            return SUCESS_CONFIRMACAO;
        }
        if (Contexto.getContexto().getCupomCliente() == null || Contexto.getContexto().getCupomCliente() == null) {
            return USERCANCEL;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = null;
        displayModel = Contexto.getContexto().getSubProcess() instanceof ProcessReimpressaoComprovante ? new LayoutDisplay(inter.getMessage(MessageEnum.IMPCOM_PRINTING)) : new LayoutDisplay(inter.getMessage(MessageEnum.IMPCOM_PRINTING), 0L, 1);
        perifericos.imprimeDisplay(displayModel);
        String[] buffer = null;
        String texto = "";
        for (int i = 0; i < Contexto.getContexto().getOpcoesImpressao().length; ++i) {
            switch (Contexto.getContexto().getOpcoesImpressao()[i]) {
                case 1: {
                    buffer = Contexto.getContexto().getCupomCliente().getLinhas();
                    break;
                }
                case 2: {
                    buffer = Contexto.getContexto().getCupomLojista().getLinhas();
                }
            }
            for (int j = 0; j < buffer.length; ++j) {
                texto = texto + buffer[j] + "\n";
            }
            texto = texto + "\n";
            if (i != 0) continue;
            texto = texto + "--------------------------------------";
            texto = texto + "\n\n";
        }
        Contexto.getContexto().setOpcoesImpressao(new int[]{1, 2});
        ExibeDialog dlg = new ExibeDialog();
        dlg.setTitle("Comprovantes");
        dlg.setTextResumo(texto);
        dlg.show();
        if (dlg.getOption() == 1) {
            return SUCESS_IMPRIME;
        }
        if (dlg.getOption() == 2) {
            return SUCESS_CONFIRMACAO;
        }
        if (dlg.getOption() == 3) {
            return SUCESS_DESFAZ;
        }
        return ERRO;
    }
}

