/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ILeituraPin;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.AbortPinPadListener;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicHabilitaPin {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ILeituraPin dados) throws ExcecaoNaoLocal {
        String pan;
        PinEMV pinEMV;
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        try {
            pinEMV = perifericos.getPinpad();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Erro ao carregar pinpad: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        logger.debug("execute :: isIntegracaoDll: " + confCTFClient.isIntegracaoDll());
        if (confCTFClient.isIntegracaoDll()) {
            if (perifericos.getEventoNaoEsperadoListener() != null) {
                if (pinEMV != null) {
                    pinEMV.removeListener(perifericos.getEventoNaoEsperadoListener());
                }
                perifericos.setEventoNaoEsperadoListener(null);
                perifericos.setEventoNaoEsperado(null);
            }
            perifericos.setEventoNaoEsperadoListener(AbortPinPadListener.getInstance(perifericos));
            if (pinEMV != null) {
                pinEMV.addListener(perifericos.getEventoNaoEsperadoListener());
            }
        }
        Criptografia cripto = dados.getCriptografia();
        logger.debug("execute :: cripto: " + (cripto != null));
        if (cripto != null) {
            pinEMV.setTipoCriptografia(cripto.getModoCriptografia());
            pinEMV.setWorkingKey(cripto.getWorkingKey());
            pinEMV.setIndiceMasterKey(cripto.getIndiceMasterKey());
        }
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && saidaApiTefC.getPanTecBan() != null) {
            logger.debug("execute :: PanTecBan");
            pan = saidaApiTefC.getPanTecBan();
            if (pan.length() < 13) {
                pan = StringUtil.completaString(pan, 13, '0', 3);
            }
            pinEMV.setNumeroCartao(pan);
            if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                if (KeyFactory.isChaveLocal()) {
                    pinEMV.setNumeroCartaoCripto(this.geraPan3DESReverso(pan));
                } else {
                    pinEMV.setNumeroCartaoCripto(saidaApiTefC.getPanSeguroPPGetPin());
                }
            }
        } else if (cripto != null && cripto.isIndiceAuttar()) {
            logger.debug("execute :: IndiceAuttar");
            String panVazio = "0000000000000";
            if (ProtocoloBibliotecaCompartilhada.isSecureCommunication() && pinEMV instanceof BibliotecaPinpad && !((BibliotecaPinpad)pinEMV).isPinpadAbecs()) {
                if (KeyFactory.isChaveLocal()) {
                    String pan3DESReverso = StringUtil.completaString(panVazio, 16, 'F', 4);
                    try {
                        pan3DESReverso = LeitorCartao.descriptografaPAN(pan3DESReverso, false);
                    }
                    catch (Exception e) {
                        logger.error("Erro ao descriptografar o PAN para gerar o 3des reverso do habilitaPin: " + e.getMessage());
                    }
                    pinEMV.setNumeroCartao(pan3DESReverso);
                } else {
                    pinEMV.setNumeroCartao(saidaApiTefC.getPanSeguroPPGetPin());
                }
            } else {
                pinEMV.setNumeroCartao(panVazio);
            }
        } else {
            pan = "";
            if (entradaApiTefC.getPAN() != null) {
                pan = entradaApiTefC.getPAN();
            }
            if (pan != null && pan.length() < 13) {
                pan = StringUtil.completaString(pan, 13, '0', 3);
            }
            pinEMV.setNumeroCartao(pan);
            if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                if (KeyFactory.isChaveLocal()) {
                    pinEMV.setNumeroCartaoCripto(this.geraPan3DESReverso(pan));
                } else {
                    pinEMV.setNumeroCartaoCripto(saidaApiTefC.getPanSeguroPPGetPin());
                }
            }
        }
        if (dados.getDadosSolicitaPin() != null) {
            DadoSolicitaPin[] dadosPin = dados.getDadosSolicitaPin();
            pinEMV.resetParms();
            for (int i = 0; i < dadosPin.length; ++i) {
                pinEMV.addDadoSolicitaPin(dadosPin[i]);
            }
        }
        try {
            PerifericoEventHandler.setActive(true);
            pinEMV.habilita(dados.getTipoLeituraPin());
            pinEMV.setCapturaSenha(dados.isCapturaSenha());
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Erro ao habilitar pinpad: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        return SUCESS;
    }

    private String geraPan3DESReverso(String pan) {
        if (pan.length() < 16) {
            pan = StringUtil.completaString(pan, 16, 'F', 4);
        }
        try {
            pan = LeitorCartao.descriptografaPAN(pan, false);
        }
        catch (Exception e) {
            logger.error("Erro descriptografar PAN: " + e.getMessage());
        }
        return pan;
    }
}

