/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.LeituraCartaoEnum;
import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.model.constants.TipoAplicacao;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.AbortPinPadListener;
import com.csi.ctfclient.tools.devices.ExcecaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.ExcecaoComunicacaoSegura;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import java.math.BigDecimal;
import java.util.Objects;

public class MicHabilitaLeitorCartao
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String CONFIGURA_PINPAD = "CONFIGURA_PINPAD";
    public static final String MSG_ERRO_COMUNICACAO_SEGURA = "ERRO CHAVE";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
        boolean deliveryInternet = entradaApiTefC.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE || entradaApiTefC.getOrigemTransacao() == OrigemTransacaoEnum.INTERNET;
        boolean typedOperation = TransactionOperationRules.isTypedOperation();
        if (deliveryInternet || typedOperation || this.isPinpadNotConfigured(dados) || Contexto.getContexto().getCartao() != null && !Contexto.getContexto().isNovaLeituraCartao()) {
            return UNECESSARY;
        }
        ILeitorCartaoHandler cardReaderHandler = this.tryGetCardReader();
        if (cardReaderHandler == null) {
            this.logger.error("Erro ao habilitar o leitor cartao");
            return this.trataErroComunicacaoPinPad(ERRO, CONFIGURA_PINPAD);
        }
        LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
        displayModel.setImagem(LayoutDisplay.imagens.aguarde_pinpad);
        perifericos.imprimeDisplay(displayModel);
        if (confCTFClient.isIntegracaoDll()) {
            if (perifericos.getEventoNaoEsperadoListener() != null) {
                cardReaderHandler.removeListener(perifericos.getEventoNaoEsperadoListener());
                perifericos.setEventoNaoEsperadoListener(null);
                perifericos.setEventoNaoEsperado(null);
            }
            perifericos.setEventoNaoEsperadoListener(AbortPinPadListener.getInstance(perifericos));
            cardReaderHandler.addListener(perifericos.getEventoNaoEsperadoListener(), true);
        }
        LeitorCartao leitorCartao = cardReaderHandler.getLeitorCartao();
        OperationEnum operationEnum = OperationEnum.getEnumByDescription(Contexto.getContexto().getTipoOperacao());
        leitorCartao.setTipoTransacaoEfetuada(operationEnum.getTipoTransacaoEfetuada());
        this.configuraLeitorParaLeituraReleitura(leitorCartao, operationEnum);
        if (entradaApiTefC.getValorTransacao() != null) {
            leitorCartao.setValorInicialTransacao(this.infValorTransacao(entradaApiTefC.getValorTransacao()));
        }
        leitorCartao.setDataTransacao(dados.getStartProcess());
        if (TransactionOperationRules.isCartaoQualidade()) {
            Contexto.getContexto().setDesabilitaContactlessProximaLeitura(true);
            leitorCartao.setActionLeituraCartao(LeituraCartaoEnum.QUALIDADE);
            leitorCartao.setActiveContactless(false);
        }
        try {
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean multiEC = config.isMultiEC();
            IdentTerminal identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
            if (!TransactionOperationRules.isCartaoQualidade()) {
                boolean pinpadSupportsContactless = perifericos.getPinpad().getInfo().isSuportaContactless();
                boolean enableContactless = true;
                if (Contexto.getContexto().isDesabilitaContactlessProximaLeitura()) {
                    this.logger.info("Cart\u00e3o contactless desabilitado para esta leitura (FALLBACK)");
                    enableContactless = false;
                } else if (!pinpadSupportsContactless) {
                    this.logger.info("Pinpad n\u00e3o suporta contactless");
                    enableContactless = false;
                } else if (!dadosInicioDia.isHabilitaContactless()) {
                    this.logger.info("Contactless desabilitado para este EC");
                    enableContactless = false;
                } else if (leitorCartao.hasIdsRedIndTab() && !leitorCartao.hasAidValidForContacless()) {
                    this.logger.info("Contactless desabilitado na carga de tabelas ");
                    enableContactless = false;
                }
                this.logger.info("Para essa transa\u00e7\u00e3o, o contactless est\u00e1 " + (enableContactless ? "LIGADO" : "DESLIGADO"));
                this.logger.info("O PinPad, quanto ao suporte contactless est\u00e1 " + (pinpadSupportsContactless ? "PRESENTE" : "N\u00c3O PRESENTE"));
                leitorCartao.setHabilitaContactless(enableContactless);
                entradaApiTefC.setCapacidadeContactlessPinpad(pinpadSupportsContactless);
                PerifericoEventHandler.setActive(true);
                leitorCartao.habilitaTrilha(1);
                leitorCartao.habilitaTrilha(2);
                leitorCartao.habilitaTrilha(3);
            }
            if (confCTFClient.getTentativasConexaoPinpad() == 0) {
                ExcecaoPerifericos ex;
                int cont = 0;
                do {
                    ++cont;
                    ex = null;
                    try {
                        leitorCartao.habilita();
                    }
                    catch (ExcecaoPerifericos e) {
                        ex = e;
                        displayModel = new LayoutDisplay("Erro no PINPAD (" + cont + ")..");
                        perifericos.imprimeDisplay(displayModel);
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } while (ex != null && cont < 10);
                if (ex != null) {
                    throw ex;
                }
            } else {
                leitorCartao.habilita();
            }
            cmosPinPad.limpaTentativaConexoes();
        }
        catch (ExcecaoInteiroInvalido e) {
            this.logger.error("Erro de inteiro invalido ao habilitar o leitor cart\u00e3o: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CONECTE_PIN_PAD, "999 - ERRO CONECTE PINPAD"));
            return ERRO;
        }
        catch (ExcecaoBibliotecaCompartilhada e) {
            this.logger.error("Erro da biblioteca compartilhada ao habilitar o leitor cartao: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.PINPAD_SEM_API_COMPARTILHADA, "PINPAD SEM API COMPARTILHADA"));
            return ERRO;
        }
        catch (ExcecaoComunicacaoSegura e) {
            this.logger.error("Erro de comunicacao segura ao habilitar a comunica\u00e7\u00e3o segura com o pinpad: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.MSG_ERRO_COMUNICACAO_SEGURA, MSG_ERRO_COMUNICACAO_SEGURA));
            return ERRO;
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error("Erro de perifericos ao habilitar o leitor cartao: " + e.getMessage());
            return this.trataErroComunicacaoPinPad(ERRO, CONFIGURA_PINPAD);
        }
        return SUCESS;
    }

    private void configuraLeitorParaLeituraReleitura(LeitorCartao leitorCartao, OperationEnum operationEnum) throws ExcecaoNaoLocal {
        this.logger.trace("Atualizando a lista de idRede/IndiceTabela e da lista de AIDS da Leitor cart\u00e3o");
        leitorCartao.setIdsRedeIndTab(Contexto.getContexto().getListIdRedeIndTab());
        leitorCartao.buildMapIdRedeIndiceAid(Contexto.getContexto().getListAID());
        leitorCartao.setTipoAplicacao(this.infTipoAplicacao(operationEnum));
        leitorCartao.setTimeStamp(CMOSPinPad.getInstance().getTimeStamp(0));
    }

    private long infValorTransacao(BigDecimal bigDecimal) {
        return bigDecimal.movePointRight(2).longValue();
    }

    private int infTipoAplicacao(OperationEnum operationEnum) {
        switch (operationEnum) {
            case OP_CREDITO: 
            case OP_CREDITO_GENERICO: 
            case OP_AUT_IATA: 
            case OP_CRED_IATA: 
            case OP_SIMULACAO_CREDIARIO_DE_CREDITO: 
            case OP_CREDIARIO_DE_CREDITO: 
            case OP_PRE_AUT_CRED: 
            case OP_CONFIRMACAO_PRE_AUT: 
            case OP_CONSULTA_FATURA_CARTAO: 
            case OP_CONSULTA_FATURA_CARTAO_DETALHADA: 
            case OP_PAGAMENTO_FATURA_CARTAO: 
            case OP_CRED_PRIVATE_LABEL: 
            case OP_PAGAMENTO_FATURA_CARTAO_CREDITO: 
            case OP_PAGAMENTO_CONTA_BANCARIA: 
            case OP_PAGAMENTO_CONTA_CONCESSIONARIA: {
                return TipoAplicacao.CREDITO.getId();
            }
            case OP_DEBITO: 
            case OP_DEBITO_GENERICO: 
            case OP_CREDIARIO_DE_DEBITO: {
                return TipoAplicacao.DEBITO.getId();
            }
            case OP_CANCELAMENTO_GENERICO: {
                if (Contexto.getContexto().getSaidaConsulta() == null || Contexto.getContexto().getSaidaConsulta().getCodigoTransacao() == null) break;
                String codigoTransacaoCancelamento = Contexto.getContexto().getSaidaConsulta().getCodigoTransacao();
                if (codigoTransacaoCancelamento.equals("12")) {
                    return TipoAplicacao.CREDITO.getId();
                }
                if (!codigoTransacaoCancelamento.equals("10")) break;
                return TipoAplicacao.DEBITO.getId();
            }
            case OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA: 
            case OP_PGTO_FICHA_COMPENSACAO: 
            case OP_PGTO_CONVENIO_COM_CONSULTA: 
            case OP_PGTO_CONVENIO: {
                if (Contexto.getContexto().getTipoPagamento() == 5) {
                    return TipoAplicacao.CREDITO.getId();
                }
                if (Contexto.getContexto().getTipoPagamento() != 4) break;
                return TipoAplicacao.DEBITO.getId();
            }
            default: {
                return TipoAplicacao.QUALQUER.getId();
            }
        }
        return TipoAplicacao.QUALQUER.getId();
    }

    private boolean isPinpadNotConfigured(Process dados) {
        ILeitorCartaoHandler leitorCartao = null;
        boolean loadException = false;
        try {
            leitorCartao = dados.getPerifericos().getLeitorCartao();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            loadException = true;
            this.logger.warn("Nao foi possivel carregar o leitor de cartoes na verificacao de configuracao: " + excecaoPerifericos.getMessage());
        }
        return leitorCartao == null && !loadException;
    }
}

