/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicHabilitaInjetarChaveDUKPT {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ICriptografiaDUKPT dados) {
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        StringBuffer str = new StringBuffer();
        str.append("02");
        str.append("062");
        str.append("K2");
        str.append(StringUtil.completaString(String.valueOf(saida.getIlksn()), 20, '0', 3));
        str.append(StringUtil.completaString(String.valueOf(saida.getIpek()), 32, '0', 3));
        str.append(StringUtil.completaString(String.valueOf(saida.getCheckValueIpek()), 8, '0', 3));
        try {
            PinEMV pinEMV = perifericos.getPinpad();
            pinEMV.setBufferGenericCommand(str.toString());
            PerifericoEventHandler.setActive(true);
            pinEMV.habilita(4);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Erro ao habilitar o pin: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        return SUCCESS;
    }
}

