/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;

public class MicHabilitaConsultaDadosEMV
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getCartao() != Cartao.CHIP && Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV) {
            this.logger.error("A transa\u00e7\u00e3o atual exige um cart\u00e3o com Chip, com ou sem contato");
            this.setIntegrationError(CodigoErroIntegracaoEnum.CARTAO_COM_CHIP_REQUERIDO, "CARTAO COM CHIP REQUERIDO");
            return ERROR;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        try {
            PinEMV pinEMV = this.tryGetPin();
            pinEMV.setReadTagParameters(saida.getRedeChip(), saida.getFuncaoGenericCommand(), saida.getTagsGenericCommand());
            pinEMV.habilita(4);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Erro ao habilitar o pin: {}", excecaoPerifericos.getMessage());
            return ERROR;
        }
        return SUCCESS;
    }
}

