/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicHabilitaCertificadoDUKPT
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        StringBuffer str = new StringBuffer();
        str.append("02");
        str.append("007");
        str.append("K1");
        str.append(StringUtil.completaString(String.valueOf(registroCriptografia.getIndiceMasterKey()), 2, '0', 3));
        str.append(StringUtil.completaString(String.valueOf(registroCriptografia.getSlotDUKPT()), 2, '0', 3));
        str.append("1");
        try {
            PinEMV pinEMV = perifericos.getPinpad();
            pinEMV.setBufferGenericCommand(str.toString());
            PerifericoEventHandler.setActive(true);
            pinEMV.habilita(4);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Nao foi possivel habilitar o pin: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        return SUCCESS;
    }
}

