/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.SubComercio;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class MicFormataCamposIntegracao
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao == null) {
            return NOT_REQUIRED;
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entradaIntegracao.isSoftDescriptorCtrl()) {
            this.logger.info(String.format("Software descriptor enviado pela AC: (%s)", entradaIntegracao.getSoftDescriptor()));
            entrada.setSoftDescriptor(entradaIntegracao.getSoftDescriptor());
        }
        if (entradaIntegracao.isMccCtrl()) {
            this.logger.info(String.format("MCC enviado pela AC: (%s)", entradaIntegracao.getMcc()));
            entrada.setMcc(entradaIntegracao.getMcc());
        }
        if (entradaIntegracao.isWalletUtilizadoCtrl()) {
            this.logger.info(String.format("Wallet utilizado enviado pela AC: (%d)", entradaIntegracao.getWalletUtilizado()));
            entrada.setWalletUtilizado(entradaIntegracao.getWalletUtilizado());
        }
        if (entradaIntegracao.isIdentificadorWalletCtrl()) {
            this.logger.info(String.format("Identificador Wallet enviado pela AC: (%s)", entradaIntegracao.getIdentificadorWallet()));
            entrada.setIdentificadorWallet(entradaIntegracao.getIdentificadorWallet());
        }
        if (entradaIntegracao.isConfigSubComercioCtrl()) {
            try {
                String buffer = entradaIntegracao.getConfigSubComercio();
                int offSet = 0;
                SubComercio subComercio = new SubComercio();
                subComercio.setId(buffer.substring(offSet, offSet + 15).trim());
                subComercio.setCnpj(buffer.substring(offSet += 15, offSet + 14));
                int tam = Integer.parseInt(buffer.substring(offSet += 14, offSet + 2));
                subComercio.setLogradouro(buffer.substring(offSet += 2, offSet + tam));
                subComercio.setCidade(buffer.substring(offSet += tam, offSet + 13).trim());
                subComercio.setEstado(buffer.substring(offSet += 13, offSet + 2));
                subComercio.setCep(buffer.substring(offSet += 2, offSet + 8));
                tam = Integer.parseInt(buffer.substring(offSet += 8, offSet + 2));
                subComercio.setRazaoSocial(buffer.substring(offSet += 2, offSet + tam));
                offSet += tam;
                tam = Integer.parseInt(buffer.substring(offSet, offSet + 2));
                subComercio.setNomeFantasia(buffer.substring(offSet += 2, offSet + tam));
                subComercio.setTelefone(buffer.substring(offSet += tam));
                entrada.setSubComercio(subComercio);
            }
            catch (Exception e) {
                this.logger.error("nao foi possivel recuperar dados do subcomercio. " + e.getMessage());
            }
            if (entradaIntegracao.isMatriculaSupervisorCtrl()) {
                entrada.setMatriculaSupervisor(entradaIntegracao.getMatriculaSupervisor());
            }
            if (entradaIntegracao.isMatriculaOperadorCtrl()) {
                entrada.setMatriculaOperador(entradaIntegracao.getMatriculaOperador());
            }
            if (entradaIntegracao.isNumeroPlanoCtrl()) {
                entrada.setCodigoPlano(entradaIntegracao.getNumeroPlano());
            }
        }
        return SUCCESS;
    }
}

