/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.ApiWebCtfResponse;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ComunicacaoHost;
import com.csi.ctfclient.apitef.model.TipoResposta;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DecisaoFinishChip;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicFinishChip
extends MicAbstractBase {
    public static final String SUCESS_APROVADA = "SUCESS_APROVADA";
    public static final String SUCCESS_APROVADA_OFF = "SUCCESS_APROVADA_OFF";
    public static final String SUCESS_NEGADA_CARTAO = "SUCESS_NEGADA_CARTAO";
    public static final String NEGADA_CARTAO_OFF = "NEGADA_CARTAO_OFF";
    public static final String SUCESS_NEGADA_HOST = "SUCESS_NEGADA_HOST";
    public static final String SUCCESS_NEGADA_HOST_REENVIO = "SUCCESS_NEGADA_HOST_REENVIO";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_PIN_PAD = "ERRO_PIN_PAD";
    public static final String ERRO_FINISH_CHIP = "ERRO_FINISH_CHIP";
    public static final int DECISION_REJECT_BY_HOST = 2;
    public static final int DECISION_REJECT_BY_CARD = 1;
    public static final int DECISION_APROVED = 0;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinEMV;
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (!saidaApiTefC.isCapturaDadosChip() || saidaApiTefC.isFluxoEMVSemFinishChip() || Contexto.getContexto().getPinInfo() == null) {
            return NOTREQUIRED;
        }
        if (Contexto.getContexto().getPinInfo().getDecisaoTomada() == DecisaoFinishChip.TRANSACAO_NEGADA_OFFLINE.getCodigoChar()) {
            Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_AUT_CARTAO));
            return UNECESSARY;
        }
        try {
            pinEMV = perifericos.getPinpad();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Nao foi possivel carregar o pinpad: " + excecaoPerifericos.getMessage());
            return this.decisionReturnErrorDefault(saidaApiTefC);
        }
        this.logger.debug("saidaApiTefC.getRetorno(): " + saidaApiTefC.getRetorno());
        if (saidaApiTefC.getRetorno() != ApiWebCtfResponse.TEF_OK.getId().intValue() && saidaApiTefC.getRetorno() != ApiWebCtfResponse.TMOUT.getId().intValue() && saidaApiTefC.getRetorno() != ApiWebCtfResponse.NAO_AUT.getId().intValue() && (saidaApiTefC.getRetorno() == ApiWebCtfResponse.ERRO_CTF.getId().intValue() || saidaApiTefC.getStatusComunicacao() == ComunicacaoHost.CONN_OK.getCodigo())) {
            return UNECESSARY;
        }
        this.setupPinEmv(saidaApiTefC, pinEMV);
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        try {
            SaidaFinishChipEMV chipEMV = pinEMV.finishChip();
            if (saidaApiTefC.getRetorno() == ApiWebCtfResponse.TEF_OK.getId().intValue() && chipEMV.getRetorno() != 0) {
                this.logger.error("Erro onde saidaApiTefC.getRetorno() == 0 && chipEMV.getRetorno() != 0 - retornando motivo 12 (DESFAZIMENTO_ERRO_PINPAD)");
                entrada.setMotivoDesfazimento(12);
                Contexto.getContexto().setErrorCode(chipEMV.getRetorno());
                return ERRO_FINISH_CHIP;
            }
            if (chipEMV.getRetorno() > 2) {
                Contexto.getContexto().setRemoveCardMessage(chipEMV.getRetorno() + " - ERRO PIN PAD");
                return ERRO_PIN_PAD;
            }
            int decision = chipEMV.getDecisao();
            if (((BibliotecaPinpad)pinEMV).isPinpadAbecs() && decision > 0) {
                decision = this.decisionAbecs(saidaApiTefC.getCodigoRespostaAutorizadora(), pinEMV.getComunicacaoHost());
            }
            this.logger.debug("Decis\u00e3o FinishiChip: " + decision);
            Contexto.getContexto().getPinInfo().setDecisaoFinishChip(decision);
            if (pinEMV.getComunicacaoHost() == ComunicacaoHost.CONN_FAIL.getCodigo()) {
                entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                entrada.setDecisaoChip(StringUtil.completaString(decision + "", 1, ' ', 3).toCharArray()[0]);
                entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                entrada.setDadosChip(null);
            }
            entrada.setStatusOffline2nd(decision);
            switch (decision) {
                case 0: {
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_APROVADA));
                    if (pinEMV.getComunicacaoHost() == ComunicacaoHost.CONN_FAIL.getCodigo()) {
                        return SUCCESS_APROVADA_OFF;
                    }
                    return SUCESS_APROVADA;
                }
                case 1: {
                    if (saidaApiTefC.getRetorno() == ApiWebCtfResponse.TEF_OK.getId().intValue() && pinEMV.getComunicacaoHost() == ComunicacaoHost.CONN_OK.getCodigo()) {
                        this.logger.trace("Nsu da negada cart\u00e3o foi configurado com NSU da transacao anterior");
                        entrada.setNsuCtfNegadaCartao(saidaApiTefC.getNsuCTF());
                    }
                    entrada.setTipoResposta(TipoResposta.CARTAO.getCodigoChar());
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    if (pinEMV.getComunicacaoHost() == ComunicacaoHost.CONN_FAIL.getCodigo()) {
                        entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                    }
                    int redeChip = Integer.parseInt(entrada.getCodigoRedeAdquirenteChip());
                    this.logger.debug("Codigo Rede Adquirente Chip: " + entrada.getCodigoRedeAdquirenteChip());
                    if (saidaApiTefC.getRetorno() != ApiWebCtfResponse.NAO_AUT.getId().intValue() && saidaApiTefC.getRetorno() != ApiWebCtfResponse.TMOUT.getId().intValue()) {
                        if (redeChip == 2) {
                            Contexto.getContexto().setFinishChipMessage("TRANSACAO NEGADA LIGUE EMISSOR");
                        } else {
                            Contexto.getContexto().setFinishChipMessage("TRANS. NAO AUT. PELO CARTAO");
                        }
                    }
                    if (redeChip == 2) {
                        Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_AUT_CARTAO_LIGUE_EMISSOR));
                    } else {
                        Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_AUT_CARTAO));
                    }
                    entrada.setMotivoDesfazimento(2);
                    if (pinEMV.getComunicacaoHost() == ComunicacaoHost.CONN_FAIL.getCodigo()) {
                        if (entrada.getCodigoRedeAdquirenteChip().equals("03")) {
                            Contexto.getContexto().setRemoveCardMessage("TENTE DE NOVO-TO");
                        }
                        return NEGADA_CARTAO_OFF;
                    }
                    return SUCESS_NEGADA_CARTAO;
                }
                case 2: {
                    if (saidaApiTefC.getMensagemDisplayPin().trim().equals("")) {
                        Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_TRANS_NAO_APROV));
                    } else {
                        Contexto.getContexto().setRemoveCardMessage(saidaApiTefC.getMensagemDisplayPin());
                    }
                    if (saidaApiTefC.isReenvioNegadaHost()) {
                        this.logger.trace("Nsu da negada cart\u00e3o foi configurado com NSU da transacao anterior");
                        entrada.setNsuCtfNegadaCartao(saidaApiTefC.getNsuCTF());
                        if (chipEMV.getDadosFinais() != null && chipEMV.getDadosFinais().length() > 0 || chipEMV.getIssuerScriptResults() != null && chipEMV.getIssuerScriptResults().length() > 0) {
                            entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                            entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                            return SUCCESS_NEGADA_HOST_REENVIO;
                        }
                    }
                    return SUCESS_NEGADA_HOST;
                }
            }
            return this.decisionReturnErrorDefault(saidaApiTefC);
        }
        catch (Exception e) {
            this.logger.error("Erro durante a execucao do finish chip: " + e.getMessage());
            if (e instanceof ExcecaoPerifericos && Contexto.getContexto().getSaidaApiTefC().getRetorno() == ApiWebCtfResponse.TEF_OK.getId().intValue()) {
                ExcecaoPerifericos erroPeriferico = (ExcecaoPerifericos)e;
                Contexto.getContexto().setErrorCode(erroPeriferico.getCodigoErroOriginal());
                entrada.setMotivoDesfazimento(2);
                return ERRO_FINISH_CHIP;
            }
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
            }
            return this.decisionReturnErrorDefault(saidaApiTefC);
        }
    }

    private void setupPinEmv(SaidaApiTefC saidaApiTefC, PinEMV pinEMV) {
        if (saidaApiTefC.getStatusComunicacao() == ComunicacaoHost.CONN_OK.getCodigo()) {
            pinEMV.setComunicacaoHost(saidaApiTefC.getStatusComunicacao());
            pinEMV.setTipoEmissor(saidaApiTefC.getTipoEmissor());
            if (saidaApiTefC.getCardIssuerResponseCode() != null) {
                pinEMV.setAuthRespCode(saidaApiTefC.getCardIssuerResponseCode());
            } else {
                pinEMV.setAuthRespCode(saidaApiTefC.getCodigoRespostaAutorizadora());
            }
            pinEMV.setCampo55(saidaApiTefC.getDadosRespostaChip());
            pinEMV.setDadosRestantes("");
            pinEMV.setTags(saidaApiTefC.getFinishChipTags().length() != 0 ? saidaApiTefC.getFinishChipTags() : saidaApiTefC.getGoOnChipMandatoryTags());
        } else {
            pinEMV.setComunicacaoHost(ComunicacaoHost.CONN_FAIL.getCodigo());
            pinEMV.setTipoEmissor(0);
            pinEMV.setAuthRespCode("00");
            pinEMV.setCampo55("");
            pinEMV.setDadosRestantes("");
            pinEMV.setTags(Contexto.getContexto().getTagsMandatorias());
        }
    }

    private String decisionReturnErrorDefault(SaidaApiTefC saidaApiTefC) {
        if (saidaApiTefC.getRetorno() == ApiWebCtfResponse.TEF_OK.getId().intValue()) {
            return ERRO_FINISH_CHIP;
        }
        return ERRO;
    }

    private int decisionAbecs(String respostaAutorizadora, int statusCommunication) {
        return !respostaAutorizadora.equals("00") && !respostaAutorizadora.equals("000") && statusCommunication == ComunicacaoHost.CONN_OK.getCodigo() ? 2 : 1;
    }
}

