/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicExibeValorResgateMonetario
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String RESGATE_NAO_PERMITIDO = "RESGATE_NAO_PERMITIDO";
    public static final String UNECESSARY = "UNECESSARY";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        if (saida != null) {
            if (saida.isExibeDisplayErroResgateMonetario()) {
                String displayResgate = "";
                if (saida.getDisplayResgateMonetario() != null) {
                    displayResgate = saida.getDisplayResgateMonetario();
                }
                LayoutDisplay displayModel = new LayoutDisplay(displayResgate, ControladorConfCTFClient.TIME_OUT_DELAY, false);
                periferico.imprimeDisplay(displayModel);
                return RESGATE_NAO_PERMITIDO;
            }
            if (!saida.isResgateMonetario()) {
                return UNECESSARY;
            }
        } else {
            return UNECESSARY;
        }
        BigDecimal valorOriginal = saida.getValorOriginalTransacao();
        BigDecimal valorTransacao = saida.getValorTransacao();
        if (valorOriginal == null || valorTransacao == null) {
            this.logger.error("Valor original ou valor da transa\u00e7\u00e3o n\u00e3o preenchido. O desconto ser\u00e1 desconsiderado. Valor Orig: " + valorOriginal + ", Valor da transa\u00e7\u00e3o: " + valorTransacao);
            return UNECESSARY;
        }
        BigDecimal valorDesconto = valorOriginal.subtract(valorTransacao);
        this.logger.info("Valor do desconto: " + valorDesconto);
        Contexto.getContexto().setValorDescontoMonetario(valorDesconto);
        DecimalFormat format = new DecimalFormat("#,##0.00");
        String valorTransacaoFormatado = "R$ " + StringUtil.completaString(format.format(valorTransacao.doubleValue()), 12, ' ', 3);
        String valorOriginalFormatado = "R$ " + StringUtil.completaString(format.format(valorOriginal.doubleValue()), 12, ' ', 3);
        periferico.limpaDisplay();
        LayoutDisplay layoutDisplay = new LayoutDisplay(2, ControladorConfCTFClient.TIME_OUT_DELAY_PLATAFORMA_PROMOCIONAL, true);
        if (saida.getDisplayResgateMonetario() != null && saida.getDisplayResgateMonetario().length() > 0) {
            layoutDisplay.addLinha(new Linha(saida.getDisplayResgateMonetario()));
            if (this.tryGetPin() != null) {
                String mensagemPinpad = saida.getDisplayResgateMonetario().length() > 16 ? saida.getDisplayResgateMonetario().substring(0, 16) : saida.getDisplayResgateMonetario();
                this.tryShowMessagePinpad(mensagemPinpad);
            }
        }
        layoutDisplay.addLinha(new Linha(inter.getMessage(MessageEnum.EXIVALRESMON_VALOR_ORIGINAL)));
        layoutDisplay.addLinha(new Linha(valorOriginalFormatado));
        layoutDisplay.addLinha(new Linha(inter.getMessage(MessageEnum.EXIVALRESMON_VALOR_COM_DESCONTO)));
        layoutDisplay.addLinha(new Linha(valorTransacaoFormatado));
        periferico.imprimeDisplay(layoutDisplay);
        try {
            Thread.sleep(ControladorConfCTFClient.TIME_OUT_DELAY_PLATAFORMA_PROMOCIONAL);
        }
        catch (InterruptedException e) {
            this.logger.info("Espera do display foi interrompida: " + e.getMessage());
        }
        return SUCCESS;
    }
}

