/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.AmountType;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.InvalidDataException;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicExibeProdutosPremmiaPontos;
import com.csi.ctfclient.operacoes.microoperacoes.MicExibeProdutosPremmiaValores;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.util.ArrayList;

public class MicExibeMenuProdutosPremmia {
    public static final String EMPTY_LIST = "LISTA_VAZIA";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_INPUT = "ENTRADA_INVALIDA";
    public static final String UNEXPECTED = "INESPERADO";
    public static final String BYPASS_VALUE_PRODUCTS = "BYPASS_PRODUTOS_VALOR";
    public static final String BYPASS_POINT_PRODUCTS = "BYPASS_PRODUTOS_PONTO";
    public static final String SELECTED_VALUE_PRODUCTS = "SELECIONADO_PRODUTOS_VALOR";
    public static final String SELECTED_POINT_PRODUCTS = "SELECIONADO_PRODUTOS_PONTO";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public static boolean containsValueProducts(String list) throws InvalidDataException {
        MicExibeProdutosPremmiaValores values = new MicExibeProdutosPremmiaValores();
        return !values.buildProductList(list).isEmpty();
    }

    public static boolean containsPointsProducts(String list) throws InvalidDataException {
        MicExibeProdutosPremmiaPontos points = new MicExibeProdutosPremmiaPontos();
        return !points.buildProductList(list).isEmpty();
    }

    public String execute(Process parent) throws ExcecaoNaoLocal {
        logger = parent.getLoggerFactory().getLogger(CTFClientCore.class);
        SaidaApiTefC ctfOut = Contexto.getContexto().getSaidaApiTefC();
        if (ctfOut.getProductList() == null) {
            logger.error("N\u00e3o foram retornados produtos do CTF");
            Contexto.getContexto().setErrorCode(-1);
            return EMPTY_LIST;
        }
        logger.debug("Lista de produtos BR Premmia: " + ctfOut.getProductList());
        try {
            if (!MicExibeMenuProdutosPremmia.containsPointsProducts(ctfOut.getProductList())) {
                if (!MicExibeMenuProdutosPremmia.containsValueProducts(ctfOut.getProductList())) {
                    return UNEXPECTED;
                }
                return BYPASS_VALUE_PRODUCTS;
            }
            if (!MicExibeMenuProdutosPremmia.containsValueProducts(ctfOut.getProductList())) {
                Contexto.getContexto().setTrnAmountType(AmountType.POINTS);
                return BYPASS_POINT_PRODUCTS;
            }
        }
        catch (InvalidDataException e) {
            logger.error("Erro ao montar a lista de produtos: " + e.getMessage());
            return ERROR;
        }
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add("PREMIO EM PONTOS");
        descriptions.add("PREMIO EM DINHEIRO");
        int selectedTypeIndex = parent.getPerifericos().showSingleChoiceMenu(parent, "BR PREMMIA", descriptions);
        logger.debug("\u00cdndice de produto selecionado = " + selectedTypeIndex);
        if (selectedTypeIndex == -1) {
            logger.info("Sele\u00e7\u00e3o de produto cancelada pelo usu\u00e1rio");
            return USER_CANCEL;
        }
        if (selectedTypeIndex >= descriptions.size()) {
            logger.info("Entrada do usu\u00e1rio fora do limite");
            return INVALID_INPUT;
        }
        if (selectedTypeIndex == 0) {
            Contexto.getContexto().setTrnAmountType(AmountType.POINTS);
            return SELECTED_POINT_PRODUCTS;
        }
        assert (selectedTypeIndex == 1);
        return SELECTED_VALUE_PRODUCTS;
    }
}

