/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.TransacoesGenericas;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MicExibeMenuDinamico {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_PRODUCT_AC = "INVALID_PRODUCT_AC";
    public static final String MSG_INVALID_PRODUCT = "OPERACAO NAO PERMITIDA";
    private static Map<Integer, Integer> mapProdutosFluxo;

    private static Map<Integer, Integer> getMapProdutosFluxo(int redeMenuDinamico) {
        if (mapProdutosFluxo == null) {
            mapProdutosFluxo = MicExibeMenuDinamico.createMapProdutosFluxo(redeMenuDinamico);
        }
        return mapProdutosFluxo;
    }

    private static Map<Integer, Integer> createMapProdutosFluxo(int redeMenuDinamico) {
        HashMap<Integer, Integer> mapaProdutosFluxo = new HashMap<Integer, Integer>();
        TransacoesGenericas transacoesGenericas = TransacoesGenericas.getInstance(redeMenuDinamico);
        mapaProdutosFluxo.put(OperationEnum.OP_CRED_DIGITADO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(OperationEnum.OP_CRED_DIGITADO_PARC_COM_JUROS.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(OperationEnum.OP_CRED_DIGITADO_PARC_SEM_JUROS.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(OperationEnum.OP_CRED_PARC_COM_JUROS.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(OperationEnum.OP_CREDITO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDITO));
        mapaProdutosFluxo.put(OperationEnum.OP_CONSULTA_CDC_COM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CONSULTA_CDC));
        mapaProdutosFluxo.put(OperationEnum.OP_CONSULTA_CDC_SEM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CONSULTA_CDC));
        mapaProdutosFluxo.put(OperationEnum.OP_CONSULTA_CDC_GENERICO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CONSULTA_CDC));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_CDC_COM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_CDC_COM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_CDC_SEM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_PARCELADO_COM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_PARCELADO_SEM_PARC_AVISTA.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_PRE_DATADO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEBITO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_CDC_GENERICO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_DEBITO));
        mapaProdutosFluxo.put(OperationEnum.OP_DEB_VOUCHER.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_VOUCHER));
        mapaProdutosFluxo.put(OperationEnum.OP_PRE_AUT_CRED.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO));
        mapaProdutosFluxo.put(OperationEnum.OP_PRE_AUT_CRED_DIGITADO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_PRE_AUTORIZACAO));
        mapaProdutosFluxo.put(OperationEnum.OP_CREDIARIO_DE_DEBITO.getKey(), new Integer(transacoesGenericas.KEY_FLUXO_CREDIARIO));
        return mapaProdutosFluxo;
    }

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        Produto[] produtosDisponiveis = saida.getProdutos();
        if (produtosDisponiveis.length == 0) {
            return UNECESSARY;
        }
        if (entradaIntegracao != null && entradaIntegracao.isOperacaoCtrl() && entradaIntegracao.getOperacao() != OperationEnum.OP_CREDITO_GENERICO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_DEBITO_GENERICO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_DEBITO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_GENERICA.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_OUTRAS_TRANSACOES.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_CANCELAMENTO_GENERICO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_CANCELAMENTO_DIGITADO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_TEF_IP_MENU_ADM.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_TEF_IP_VENDA_CARTAO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_TEF_IP_ENVIO_FACIL.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_TEF_IP_CHEQUE.getKey().intValue()) {
            int keyFluxoSelecionadoOperacao = MicExibeMenuDinamico.getMapProdutosFluxo(saida.getRedeMenuDinamico()).get(new Integer(entradaIntegracao.getOperacao()));
            ArrayList<Produto> listProdutosDisponiveis = new ArrayList<Produto>();
            for (int i = 0; i < produtosDisponiveis.length; ++i) {
                Produto produto = produtosDisponiveis[i];
                if (produto.getKeyFluxo() != keyFluxoSelecionadoOperacao) continue;
                listProdutosDisponiveis.add(produto);
            }
            Object[] objects = listProdutosDisponiveis.toArray();
            produtosDisponiveis = new Produto[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                produtosDisponiveis[i] = (Produto)objects[i];
            }
            if (produtosDisponiveis.length < 1) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, inter.getMessage(MessageEnum.EXIMENDIN_INVALID_PRODUCT)));
                return INVALID_PRODUCT_AC;
            }
        }
        if (produtosDisponiveis.length > 10) {
            throw new IllegalArgumentException("N\u00e3o existem mais teclas para a sele\u00e7\u00e3o do produto");
        }
        if (produtosDisponiveis.length == 1) {
            Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtosDisponiveis[0].getCodigo());
            Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtosDisponiveis[0].getKeyFluxo());
            Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtosDisponiveis[0].getCodigoBandeira());
            return SUCESS;
        }
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.EXIMENDIN_TITLE), true);
        int iTecla = 1;
        for (int i = 0; i < produtosDisponiveis.length; ++i) {
            Produto produto = produtosDisponiveis[i];
            layoutMenu.addItem(new ItemMenu(produto.getDescricao(), String.valueOf(iTecla++)));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtosDisponiveis[opcao - 1].getCodigo());
        Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtosDisponiveis[opcao - 1].getKeyFluxo());
        Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtosDisponiveis[opcao - 1].getCodigoBandeira());
        return SUCESS;
    }
}

