/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.Formatter;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicExibeMensagemInjecaoDUKPT
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        String[] mensagens = Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_INJECAO_MANUAL_CHAVE_DUKPT.getDescription()) ? Contexto.getContexto().getSaidaApiTefC().getDisplayCTF() : new String[]{inter.getMessage(MessageEnum.EXIMENINJDUK_TITLE1), inter.getMessage(MessageEnum.EXIMENINJDUK_TITLE2)};
        try {
            this.exibeGrupoMensagens(periferico, mensagens);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Erro ao exibir grupo de mensagens: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        return SUCCESS;
    }

    private boolean exibeGrupoMensagens(ControladorPerifericos periferico, String[] mensagens) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        boolean retorno = false;
        if (mensagens != null && mensagens.length > 0) {
            for (int i = 0; i < mensagens.length; ++i) {
                String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(mensagens[i]) : mensagens[i].split("#");
                this.exibeMensagemComDelay(periferico, msgs);
            }
            retorno = true;
        }
        return retorno;
    }

    private void exibeMensagemComDelay(ControladorPerifericos perifericos, String[] msg) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        BibliotecaPinpad pinPad = (BibliotecaPinpad)perifericos.getPinpad();
        LayoutDisplay displayModel = new LayoutDisplay();
        for (int i = 0; i < msg.length; ++i) {
            displayModel.addLinha(new Linha(msg[i]));
        }
        perifericos.imprimeDisplay(displayModel);
        try {
            Thread.sleep(ControladorConfCTFClient.TIME_OUT_DELAY);
        }
        catch (InterruptedException e) {
            this.logger.info("Espera do display foi interrompida: " + e.getMessage());
        }
        pinPad.setMsgDisplay(pinPad.getMsgPrompt());
    }
}

