/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;

public class MicExibeDadosCartaoPrepago {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        BigDecimal valorPago;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getValorTransacao() != null) {
            return UNECESSARY;
        }
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_ATIVACAO_PRE_AUTORIZACAO_CARTAO_PREPAGO.getKey().intValue() && !Contexto.getContexto().isSubFluxoConsulta()) {
            return UNECESSARY;
        }
        if (entradaIntegracao.isIgnorarExibirDadosAtivacaoCartaoPrepagoCtrl() && entradaIntegracao.isIgnorarExibirDadosAtivacaoCartaoPrepago()) {
            logger.info("Ignorando a exibi\u00e7\u00e3o dos dados do cart\u00e3o pr\u00e9-pago");
            return UNECESSARY;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        logger.debug("isPrePagoValorFixo --> " + this.isPrePagoValorFixo());
        BigDecimal valorCartaoPrepago = this.isPrePagoValorFixo() ? saida.getValorCartaoPrepago() : Contexto.getContexto().getValorCartaoPrePagoVariavel();
        BigDecimal valorBonus = saida.getValorBonus();
        BigDecimal valorAtivacao = saida.getValorAcrescimo();
        BigDecimal valorDesconto = saida.getValorDesconto();
        if (this.isPrePagoValorFixo()) {
            valorPago = saida.getValorTransacao();
        } else {
            valorPago = Contexto.getContexto().getValorCartaoPrePagoVariavel();
            if (BooleanUtils.negate(Objects.isNull(valorBonus)).booleanValue()) {
                valorPago = valorPago.add(valorBonus);
            }
            if (BooleanUtils.negate(Objects.isNull(valorAtivacao)).booleanValue()) {
                valorPago = valorPago.add(valorAtivacao);
            }
            if (BooleanUtils.negate(Objects.isNull(valorDesconto)).booleanValue()) {
                valorPago = valorPago.subtract(valorDesconto);
            }
        }
        LayoutDisplay displayModel = new LayoutDisplay(2);
        if (entradaIntegracao.getOperacao() == OperationEnum.OP_RECARGA_CARTAO_PREPAGO_POSA.getKey().intValue()) {
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.EXIDADORECCARTAO)));
        } else {
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.EXIDADATIVCARPRE)));
        }
        displayModel.addLinha(new Linha(""));
        if (valorCartaoPrepago != null) {
            displayModel.addLinha(new Linha("CREDITO CARTAO:" + StringUtil.completaString(format.format(valorCartaoPrepago.doubleValue()), 15, ' ', 3)));
        }
        if (valorBonus != null) {
            displayModel.addLinha(new Linha("BONUS:         " + StringUtil.completaString(format.format(valorBonus.doubleValue()), 15, ' ', 3)));
        }
        if (valorAtivacao != null) {
            if (entradaIntegracao.getOperacao() == OperationEnum.OP_RECARGA_CARTAO_PREPAGO_POSA.getKey().intValue()) {
                displayModel.addLinha(new Linha("TAXA RECARGA: " + StringUtil.completaString(format.format(valorAtivacao.doubleValue()), 15, ' ', 3)));
            } else {
                displayModel.addLinha(new Linha("TAXA ATIVACAO: " + StringUtil.completaString(format.format(valorAtivacao.doubleValue()), 15, ' ', 3)));
            }
        }
        if (valorDesconto != null) {
            displayModel.addLinha(new Linha("DESCONTO:      " + StringUtil.completaString(format.format(valorDesconto.doubleValue()), 15, ' ', 3)));
        }
        displayModel.addLinha(new Linha("VALOR PAGO:    " + StringUtil.completaString(format.format(valorPago.doubleValue()), 15, ' ', 3)));
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return SUCCESS;
        }
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        return SUCCESS;
    }

    private boolean isPrePagoValorFixo() {
        return Objects.isNull(Contexto.getContexto().getValorCartaoPrePagoVariavel());
    }
}

