/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.ControladorTransacaoInicioDia;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MicExecutaInicioDia
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_AC = "ERROR_AC";

    @Override
    public String derivedExecute(Process dados) {
        int modoEntrada = 0;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        try {
            ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            ControladorTransacaoInicioDia controlador = new ControladorTransacaoInicioDia();
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean opInicioDia = entradaIntegracao != null && entradaIntegracao.getOperacao() == OperationEnum.OP_INICIO_DIA.getKey().intValue();
            boolean delivery = entradaIntegracao != null && entradaIntegracao.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
            boolean multiEC = config.isMultiEC();
            this.setPinpadData(modoEntrada);
            if (opInicioDia || multiTerminal || delivery) {
                controlador.executaInicioDia(entradaIntegracao);
            } else {
                ControladorPerifericos perifericos = dados.getPerifericos();
                LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.EXEINIDIA_INICIO_DIA));
                perifericos.imprimeDisplay(displayModel);
                if (entradaIntegracao != null && multiEC) {
                    controlador.executaInicioDia(entradaIntegracao);
                } else {
                    controlador.executaInicioDia();
                }
            }
            SaidaApiTefC saida = controlador.getSaida();
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() > 0) {
                Contexto.getContexto().atualizaEntradaApiTefC(controlador.getEntrada());
            }
            ControladorCriptografia.getTabelaCriptografia(saida);
            if (saida.getRetorno() != 0) {
                return ERRO;
            }
            if (!multiTerminal && ProtocoloBibliotecaCompartilhada.isSecureCommunication() && KeyFactory.isChaveLocal()) {
                KeyFactory.generateKeys();
            }
            Contexto.getContexto().getEntradaApiTefC().setIndiceChaveTerminal(KeyFactory.getIndiceChave());
            if (!multiTerminal) {
                ControladorAIDsGetCard controladorAIDsGetCard;
                IdentTerminal identTerminal;
                if (multiEC) {
                    ControladorMultiEC controladorMultiEC = ControladorMultiEC.getInstance();
                    try {
                        if (Objects.nonNull(entradaIntegracao) && StringUtils.isNotBlank(entradaIntegracao.getIdentificadorMultiEC())) {
                            identTerminal = controladorMultiEC.determinarTerminal(entradaIntegracao.getIdentificadorMultiEC());
                        }
                        identTerminal = this.getIdentTerminal();
                    }
                    catch (Exception e) {
                        this.logger.error("Erro ao identificar terminal Multi EC: " + e.getMessage());
                        return ERRO;
                    }
                } else {
                    identTerminal = new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                }
                if ((controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal)).getMapAid() == null) {
                    try {
                        this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Terminal n\u00e3o possui mapa de AIDs");
                        CMOSPinPad.getInstance().solicitarCargaTabelas(0);
                    }
                    catch (Exception e) {
                        this.logger.warn("Nao foi possivel solicitar a carga de tabelas: " + e.getMessage());
                    }
                }
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error("Erro ao recuperar os dados do PINPAD: " + e.getMessage());
            super.setIntegrationError(CodigoErroIntegracaoEnum.CONECTE_PIN_PAD, "999 - ERRO CONECTE PINPAD");
            return ERRO_AC;
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("n\u00e3o foi poss\u00edvel realizar a transa\u00e7\u00e3o de inicio dia. " + e.getMessage());
            return ERRO;
        }
        return SUCESS;
    }
}

