/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractTrataRetornoReenvioNegadaHost;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.SimpleDateFormat;
import java.util.Objects;

public class MicEnvioTrasacaoCredito
extends MicAbstractTrataRetornoReenvioNegadaHost {
    @Override
    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (OperationEnum.OP_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "24";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "25";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "1E";
                }
                if (saidaApiTefC.isRotativoHabilitado()) {
                    return "24";
                }
            } else if (Contexto.getContexto().isCartaoNaoDigitado()) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "12";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "22";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "21";
                }
                if (saidaApiTefC.isRotativoHabilitado()) {
                    return "12";
                }
            }
        } else if (OperationEnum.OP_CREDITO_PRIMEIRA_COMPRA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return "48";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "54";
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA && entradaApiTefC.getNumeroParcelas() > 1) {
                    return "54";
                }
            }
        } else {
            if (OperationEnum.OP_PAGAMENTO_FATURA_CARTAO_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return "GR";
            }
            if (OperationEnum.OP_PAGAMENTO_CONTA_BANCARIA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return "GT";
            }
            if (OperationEnum.OP_PAGAMENTO_CONTA_CONCESSIONARIA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return "GS";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ConfCTFClient conf = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        boolean multiTerminal = false;
        if (entradaIntegracao != null) {
            multiTerminal = entradaIntegracao.isMultiTerminal();
            if (entradaIntegracao.isMccCtrl()) {
                entrada.setMcc(entradaIntegracao.getMcc());
            }
            if (Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef() != null) {
                entrada.setDadosComplementaresTef(Contexto.getContexto().getEntradaIntegracao().getDadosComplementaresTef());
            }
            if (Contexto.getContexto().getEntradaIntegracao().getTipoProduto() != null) {
                entrada.setTipoProduto(Contexto.getContexto().getEntradaIntegracao().getTipoProduto());
            }
            if (entradaIntegracao.isCodigoTabelaCtrl()) {
                entrada.setCodigoTabela(entradaIntegracao.getCodigoTabela());
            } else if (conf.getCodigoTabela() > 0) {
                entrada.setCodigoTabela(conf.getCodigoTabela());
            }
        }
        if (!multiTerminal && !Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            displayModel.setImagem(LayoutDisplay.imagens.aguarde_autorizacao);
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
            entrada.setNumeroParcelas(1);
        }
        if (!(multiTerminal || Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost() || TransactionOperationRules.isTypedOperation())) {
            this.tryShowMessagePinpad(inter.getMessage(MessageEnum.PROCESS_PINPAD_TITLE));
        }
        StringBuilder bit62Formatado = new StringBuilder();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (entrada.getDataEmissao() != null) {
            bit62Formatado.append(simpleDateFormat.format(entrada.getDataEmissao()));
        } else {
            bit62Formatado.append("00000000");
            entrada.setDataEmissao(null);
        }
        if (entrada.getNumeroCiclos() >= 0) {
            String ciclos = StringUtil.completaString(entrada.getNumeroCiclos() + "", 2, '0', 3);
            bit62Formatado.append(ciclos);
        } else {
            bit62Formatado.append("00");
            entrada.setNumeroCiclos(0);
        }
        if (entrada.getCodigoAutorizacao() != null) {
            bit62Formatado.append(StringUtil.completaString(entrada.getCodigoAutorizacao(), 6, '0', 3));
        }
        entrada.setAdicionais(bit62Formatado.toString());
        SaidaApiTefC saidaAtual = Contexto.getContexto().getSaidaApiTefC();
        if (Contexto.getContexto().getSaidaApiTefC().isFluxoChipNaoEMV()) {
            saidaAtual.setCapturaDadosChip(Contexto.getContexto().getSaidaApiTefC().getCapturaDadosChip());
        }
        TransactionOperationRules.validaAprovacaoParcial(entrada, Contexto.getContexto().getSaidaApiTefC(), entradaIntegracao, conf);
        return this.genericExecute(dados);
    }
}

