/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractTrataRetornoReenvioNegadaHost;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.util.Objects;

public class MicEnvioTransacaoPreAutorizacao
extends MicAbstractTrataRetornoReenvioNegadaHost {
    @Override
    protected String getCodigoTransacao(Process dados) {
        if (OperationEnum.OP_PRE_AUT_CRED.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getSaidaApiTefC().isFinanciamentoPreAutHabilitado()) {
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                    return "GU";
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                    return "GV";
                }
            }
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                return "7D";
            }
            if (Contexto.getContexto().isCartaoNaoDigitado()) {
                return "5F";
            }
        } else if (OperationEnum.OP_ALTERACAO_PRE_AUT.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getEntradaApiTefC().getValorTransacao() == null || Contexto.getContexto().getEntradaApiTefC().getValorTransacao().equals(BigDecimal.ZERO)) {
                return "GJ";
            }
            return "GI";
        }
        throw new IllegalStateException("C\u00f3digo da transa\u00e7\u00e3o n\u00e3o encontrada");
    }

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        String bit62Formatado = "";
        if (entrada.getValorParcela() != null) {
            bit62Formatado = entrada.getValorParcela().toString();
        }
        bit62Formatado = StringUtil.completaString(bit62Formatado, 20, '0', 3);
        entrada.setAdicionais(bit62Formatado);
        return this.genericExecute(dados);
    }
}

