/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractTrataRetornoReenvioNegadaHost;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.SimpleDateFormat;
import java.util.Objects;

public class MicEnvioTransacaoConfirmacaoPreAutorizacao
extends MicAbstractTrataRetornoReenvioNegadaHost {
    private static final String PLANO_A_VISTA_DIGITADO = "A0";
    private static final String PLANO_ADMINISTRADORA_DIGITADO = "1K";
    private static final String PLANO_LOJISTA_DIGITADO = "1J";
    private static final String PLANO_A_VISTA = "9F";
    private static final String PLANO_ADMINISTRADORA = "1I";
    private static final String PLANO_LOJISTA = "1H";

    @Override
    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (OperationEnum.OP_CONFIRMACAO_PRE_AUT.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return PLANO_A_VISTA_DIGITADO;
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                    if (entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA_DIGITADO;
                    }
                    return PLANO_ADMINISTRADORA_DIGITADO;
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                    if (entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA_DIGITADO;
                    }
                    return PLANO_LOJISTA_DIGITADO;
                }
            } else if (Contexto.getContexto().isCartaoNaoDigitado()) {
                if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                    return PLANO_A_VISTA;
                }
                if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                    if (entradaApiTefC.getNumeroParcelas() == 0 || entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA;
                    }
                    return PLANO_ADMINISTRADORA;
                }
                if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                    if (entradaApiTefC.getNumeroParcelas() == 0 || entradaApiTefC.getNumeroParcelas() == 1) {
                        return PLANO_A_VISTA;
                    }
                    return PLANO_LOJISTA;
                }
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        ConfCTFClient conf = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost() && !conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
            displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(ControladorCriptografia.getTabelaCriptografia());
        if (entrada.getNumeroParcelas() == -1) {
            entrada.setNumeroParcelas(0);
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && conf.isIntegracaoWeb()) {
            entrada.setNsuCtf(Contexto.getContexto().getEntradaIntegracao().getNsuCTF());
        }
        String bit62 = "";
        if (entrada.getDataTransacao() != null) {
            bit62 = new SimpleDateFormat("ddMM").format(entrada.getDataTransacao());
        }
        if (entrada.getCodigoAutorizacao() != null) {
            bit62 = bit62 + StringUtil.completaString(entrada.getCodigoAutorizacao(), 6, '0', 3);
        }
        String bit62Formatado = StringUtil.completaString(bit62, 10, '0', 3);
        entrada.setAdicionais(bit62Formatado);
        return this.genericExecute(dados);
    }
}

