/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnicaManual;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicEnvioTransacaoBaixaTecnicaManual {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String TEST = "TEST";
    private static final String OPERACAO = "2Y";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dado) throws ExcecaoNaoLocal {
        logger = dado.getLoggerFactory().getLogger(CTFClientCore.class);
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dado.getPerifericos();
        DadosBaixaTecnicaManual dadoBaixaTecnicaManual = Contexto.getContexto().getBaixaTecnicaManual();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRABAITEC_SOLICITACAO1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRABAITEC_SOLICITACAO2)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.ENVTRABAITEC_SOLICITACAO3)));
        periferico.imprimeDisplay(displayModel);
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao(OPERACAO);
        entrada.setTimestamp(new Date());
        entrada.setTipoPin("16");
        entrada.setTimeoutCtf(50);
        try {
            SaidaGetInfoEMV saidaPin = periferico.getPinpad().getInfo();
            String numeroSeriePinAtual = saidaPin.getNumSeriePinpad().trim();
            entrada.setNumeroSeriePin(numeroSeriePinAtual);
            entrada.setRetornoGetInfo(saidaPin.getRetorno());
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.warn("Nao foi possivel ler o numero de serie do pinpad: " + excecaoPerifericos.getMessage());
        }
        String baixaTecnica = StringUtil.completaString(dadoBaixaTecnicaManual.getNumeroOS(), 8, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getIdentificacaoTecnico(), 5, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getNomeEstabelecimento(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getEnderecoEstabelecimento(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getTelefoneEstabelecimento(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(new SimpleDateFormat("ddMMyy").format(dadoBaixaTecnicaManual.getDataBaixaTecnica()), 6, '0', 3);
        baixaTecnica = baixaTecnica + StringUtil.completaString(new SimpleDateFormat("HHmm").format(dadoBaixaTecnicaManual.getDataBaixaTecnica()), 4, '0', 3);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getCodigoCarga(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getCodigoOcorrencia(), 8, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getEPSCredenciada(), 20, ' ', 4);
        entrada.setBaixaTecnica(baixaTecnica);
        entrada.setClientSuportaPlataformaPromocional(true);
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        SaidaApiTefC saidaApiTefC = dado.getApitef().solicitacao(ident, entrada);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        if (saidaApiTefC.getRetorno() == 0) {
            return SUCESS;
        }
        logger.info("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
        return ERRO;
    }
}

