/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.SubField;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ICargaTabelasPinpad;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.util.DateUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MicEnvio2M {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ICargaTabelasPinpad dado) throws ExcecaoNaoLocal {
        ILeitorCartaoHandler leitorCartao;
        logger = dado.getLoggerFactory().getLogger(CTFClientCore.class);
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.ENV2M_ATUALIZANDO));
        perifericos.imprimeDisplay(displayModel);
        try {
            leitorCartao = perifericos.getLeitorCartao();
            Objects.requireNonNull(leitorCartao);
        }
        catch (Exception exception) {
            logger.error((Object)("Nao foi possivel carregar o leitor de cartoes: " + exception.getMessage()), exception);
            return ERRO;
        }
        try {
            SimpleDateFormat dateFormat;
            Date timestampDate;
            String timestamp;
            Map<String, List<String>> cacheTabelas = CMOSPinPad.getInstance().getCacheCargaTabelas(0);
            if (cacheTabelas != null && (timestamp = CMOSPinPad.getInstance().getTimeStamp(0)) != null && DateUtil.equalsData(timestampDate = (dateFormat = new SimpleDateFormat("ddMMyyyy")).parse(timestamp.substring(0, 8)), new Date())) {
                logger.info("cache de tabelas valido.");
                dado.setConteudoTabelas(cacheTabelas);
                SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                saidaApiTefC.setRetorno(0);
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                return SUCESS;
            }
        }
        catch (Exception e) {
            logger.warn("nao foi possivel validar cache da carga de tabelas. " + e.getMessage());
        }
        PerifericoEventHandler.setActive(false);
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(0);
        ConfCTFClient conf = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        if (conf.isIntegracaoAndroid() && conf.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(conf.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        GetInfo getInfoEMV = Contexto.getContexto().getDadosGetInfo();
        if (getInfoEMV != null) {
            entrada.setFabricantePinpad(getInfoEMV.getFabricante());
            entrada.setModeloHardware(getInfoEMV.getModeloHardware());
            entrada.setVersaoFirmwarePinpad(getInfoEMV.getVersaoFirmware());
            entrada.setVersaoEspecificacao(getInfoEMV.getVersaoEspecificao());
            entrada.setVersaoAplicacaoBasica(getInfoEMV.getVersaoAplicacao());
            entrada.setNumeroSeriePin(getInfoEMV.getNumeroSerie());
        }
        entrada.setDataCliente(dado.getStartProcess());
        entrada.setOperacao("2M");
        int redeChip = leitorCartao.getRedeAdquirente();
        entrada.setCodigoRedeAdquirenteChip(redeChip);
        entrada.setCodigoRedeCargaTabelaPin("00");
        entrada.setIndiceCargaTabelaPin(0);
        entrada.setFlagCargaTabela(true);
        entrada.setTipoBibliotecaPinpad(1);
        try {
            entrada.setVersaoEspecificacao(perifericos.getPinpad().getInfo().getVersaoEspecificacao());
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Erro ao ler informacoes do pinpad: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        if (conf.isMultiEC()) {
            entrada.setMultiEC(conf.isMultiEC());
            entrada.setCodigoGrupoMultiEC(conf.getCodigoGrupoMultiEC());
        }
        boolean solicitacarga = true;
        HashMap<String, List<String>> tabelas = new HashMap<String, List<String>>();
        int retries = 0;
        int maxRetries = 3;
        int indiceCarga = 1;
        do {
            List list;
            perifericos.imprimeDisplay(new LayoutDisplay(inter.getMessage(MessageEnum.ENV2M_ATUALIZANDO) + " (" + indiceCarga + ")"));
            SaidaApiTefC saida = dado.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                if (retries < maxRetries) {
                    logger.warn("Erro na tentativa de carga de tabelas. Efetuando tentativa " + ++retries + " de " + maxRetries + ".");
                    continue;
                }
                CMOSPinPad.getInstance().refazerCargaTabelas(redeChip);
                leitorCartao.setSolicitaCargaTabelas(LeitorCartao.ERRO_SOLICITA_CARGA_TABELA);
                Contexto.getContexto().atualizaEntradaApiTefC(entrada);
                return ERRO;
            }
            retries = 0;
            solicitacarga = saida.isSolicitaCargaTabela();
            if (!saida.getTabela1Pin().trim().equals("")) {
                if (tabelas.containsKey(SubField.TAB1_PIN.getCode())) {
                    list = (List)tabelas.get(SubField.TAB1_PIN.getCode());
                    list.addAll(this.converteDadosTabelaPin(saida.getTabela1Pin()));
                } else {
                    tabelas.put(SubField.TAB1_PIN.getCode(), this.converteDadosTabelaPin(saida.getTabela1Pin()));
                }
            }
            if (!saida.getTabela2Pin().trim().equals("")) {
                if (tabelas.containsKey(SubField.TAB2_PIN.getCode())) {
                    list = (List)tabelas.get(SubField.TAB2_PIN.getCode());
                    list.addAll(this.converteDadosTabelaPin(saida.getTabela2Pin()));
                } else {
                    tabelas.put(SubField.TAB2_PIN.getCode(), this.converteDadosTabelaPin(saida.getTabela2Pin()));
                }
            }
            if (!saida.getTabela3Pin().trim().equals("")) {
                if (tabelas.containsKey(SubField.TAB3_PIN.getCode())) {
                    list = (List)tabelas.get(SubField.TAB3_PIN.getCode());
                    list.addAll(this.converteDadosTabelaPin(saida.getTabela3Pin()));
                } else {
                    tabelas.put(SubField.TAB3_PIN.getCode(), this.converteDadosTabelaPin(saida.getTabela3Pin()));
                }
            }
            if (!saida.getTabela1PinSegundaLeitura().trim().equals("")) {
                if (tabelas.containsKey(SubField.TAB1_PIN_SEGUNDA_LEITURA.getCode())) {
                    list = (List)tabelas.get(SubField.TAB1_PIN_SEGUNDA_LEITURA.getCode());
                    list.addAll(this.converteDadosTabelaPin(saida.getTabela1PinSegundaLeitura()));
                } else {
                    tabelas.put(SubField.TAB1_PIN_SEGUNDA_LEITURA.getCode(), this.converteDadosTabelaPin(saida.getTabela1PinSegundaLeitura()));
                }
            }
            entrada.setIndiceCargaTabelaPin(saida.getIndiceTabelaPinpad());
            entrada.setCodigoRedeCargaTabelaPin("00");
            ++indiceCarga;
        } while (solicitacarga);
        if (conf.isIntegracaoAndroid() && !conf.isIntegracaoPOSTefDigital()) {
            CMOSPinPad.getInstance().setCacheCargaTabelas(0, tabelas);
        }
        dado.setConteudoTabelas(tabelas);
        return SUCESS;
    }

    public List<String> converteDadosTabelaPin(String registros) {
        int offset;
        ArrayList<String> vector = new ArrayList<String>();
        if (registros == null) {
            return vector;
        }
        for (int tam = 0; tam < registros.length(); tam += offset) {
            String strTam = registros.substring(tam, tam + 4);
            String strPin = registros.substring(tam + 4, tam + 7);
            offset = Integer.parseInt(strTam);
            int offsetPin = Integer.parseInt(strPin);
            vector.add(registros.substring(tam += 4, offsetPin + tam));
        }
        return vector;
    }
}

