/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Date;

public class MicEnvio1FReimpressao
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";

    @Override
    public String derivedExecute(Process dado) throws ExcecaoNaoLocal {
        boolean delivery;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos conPerifericos = dado.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        entrada.setOperacao("1F");
        boolean bl = delivery = entrada.getOrigemTransacao() == OrigemTransacaoEnum.TELEFONE;
        if (!delivery) {
            try {
                PinEMV pin = dado.getPerifericos().getPinpad();
                entrada.setNumeroSeriePin(pin.getInfo().getNumSeriePinpad());
                entrada.setTipoPin("16");
                if (conBaixaTecnica.verificaNecessidadeBaixaTecnica(dado)) {
                    entrada.setFlagBaixaTecnicaVisanet('2');
                }
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                this.logger.warn("Nao foi possivel coletar os dados do pinpad: " + excecaoPerifericos.getMessage());
                entrada.setTipoPin("**");
            }
        } else {
            entrada.setTipoPin("**");
        }
        Date dataAtual = new Date();
        entrada.setDataCliente(dataAtual);
        entrada.setTimeoutCtf(15);
        entrada.setOperacaoConsultada("F7");
        entrada.setNumeroTransacao(1);
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.ENV1FREI_REQUEST));
        conPerifericos.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dado.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(saida.getRetorno() == 0 && (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2'));
        if (saida.getRetorno() == 0) {
            if (saida.isSolicitaCargaTabela()) {
                this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Carga solicitada pelo CTFServer");
                CMOSPinPad.getInstance().solicitarCargaTabelas(0);
            }
            return SUCESS;
        }
        entrada.setNsuCtfTransacaoOriginal(0);
        entrada.setDataTransacao(null);
        return FAIL;
    }
}

