/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;

public class MicEnvio1FRecargaTelefone
extends MicAbstractEnvio1F {
    private static final String CONSULTA_TELEFONE = "FH";
    private static final String CONSULTA_VALORES = "F4";
    private static final String RECARGA_TELEFONE = "F5";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = this.createIdentTerminal(config);
        DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
        if (!config.isCapturaTelefonePinpad() || !dadosInicioDia.isWkAuttarHabilitada()) {
            return "UNECESSARY";
        }
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        entradaApiTefC.setInfo(entradaApiTefC.getCodigoAutorizadora());
        return this.genericExecute(dados);
    }

    protected IdentTerminal createIdentTerminal(ConfCTFClient config) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && (entradaIntegracao.isMultiTerminal() || config.isMultiEC())) {
            return Contexto.getContexto().getEntradaIntegracao().getIdentTerminal();
        }
        return new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
    }

    @Override
    protected String getCodigoTransacao(Process dados1f) {
        if (OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return CONSULTA_VALORES;
        }
        if (OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return RECARGA_TELEFONE;
        }
        if (OperationEnum.OP_CONSULTA_TELEFONE_CREDITO_DIGITAL.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return CONSULTA_TELEFONE;
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

