/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;

public class MicEnvio1FCorrespondenteBancario
extends MicAbstractEnvio1F {
    public static final String ERROR_CTF = "ERROR_CTF";
    private String codigoTransacao;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ContextoCTFClient contexto = Contexto.getContexto();
        EntradaApiTefC entradaApiTefC = contexto.getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = contexto.getSaidaApiTefC();
        if (contexto.isSubProcessConsulta() || saidaApiTefC != null && saidaApiTefC.getRetorno() == 0 && entradaApiTefC != null && entradaApiTefC.getCodigoTransacao().equals("1F")) {
            return "UNECESSARY";
        }
        if (entradaApiTefC != null && entradaApiTefC.getDataVencimentoCorBan() != null) {
            entradaApiTefC.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
        }
        if (entradaApiTefC != null) {
            this.preparaCorrespondenteBancario(entradaApiTefC);
        }
        this.setCodigoTransacao();
        String retorno = this.genericExecute(dados);
        saidaApiTefC = contexto.getSaidaApiTefC();
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 10 && "0203".equals(saidaApiTefC.getCodigoErro())) {
            return ERROR_CTF;
        }
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() == 0) {
            if (this.isPagamentoInicial()) {
                contexto.setConsultaObrigatoria(saidaApiTefC.isConsultaObrigatoria());
                contexto.setCorbanExecutaSubfluxos(saidaApiTefC.isCorbanExecutaSubfluxos());
            } else {
                this.setSaidaApiTefCFromConsultaCorban(saidaApiTefC);
            }
        }
        return retorno;
    }

    protected void setSaidaApiTefCFromConsultaCorban(SaidaApiTefC saidaApiTefC) {
        SaidaApiTefC saidaConsultaCorban = Contexto.getContexto().getSaidaConsulta();
        if (saidaConsultaCorban != null) {
            this.logger.info("Utilizando valores da Consulta CORBAN anterior");
            saidaApiTefC.setValorTransacao(saidaConsultaCorban.getValorTransacao());
            saidaApiTefC.setCapturaAcrescimo(saidaConsultaCorban.isCapturaAcrescimo());
            saidaApiTefC.setCapturaDesconto(saidaConsultaCorban.isCapturaDesconto());
            saidaApiTefC.setValorDesconto(saidaConsultaCorban.getValorDesconto());
            saidaApiTefC.setValorAcrescimo(saidaConsultaCorban.getValorAcrescimo());
            saidaApiTefC.setValorTotalJaCalculado(saidaConsultaCorban.isValorTotalJaCalculado());
            saidaApiTefC.setPermiteAlteracaoValorPagamentoCorban(saidaConsultaCorban.isPermiteAlteracaoValorPagamentoCorban());
        } else {
            this.logger.info("Sem sa\u00edda da consulta corban");
        }
    }

    protected void setCodigoTransacao() {
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        if (tipoOperacao.equals(OperationEnum.OP_CONSULTA_FICHA_COMPENSACAO.getDescription())) {
            this.codigoTransacao = "E4";
        } else if (tipoOperacao.equals(OperationEnum.OP_CONSULTA_CONVENIO.getDescription())) {
            this.codigoTransacao = "E5";
        } else {
            int tipoPagamento = Contexto.getContexto().getTipoPagamento();
            if (tipoOperacao.equals(OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getDescription()) || tipoOperacao.equals(OperationEnum.OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA.getDescription())) {
                this.codigoTransacao = tipoPagamento == 4 ? "2T" : (tipoPagamento == 5 ? "EY" : "E6");
            } else if (tipoOperacao.equals(OperationEnum.OP_PGTO_CONVENIO.getDescription()) || tipoOperacao.equals(OperationEnum.OP_PGTO_CONVENIO_COM_CONSULTA.getDescription())) {
                this.codigoTransacao = tipoPagamento == 4 ? "2P" : (tipoPagamento == 5 ? "EZ" : "E7");
            } else {
                throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
            }
        }
    }

    protected void preparaCorrespondenteBancario(EntradaApiTefC entradaApiTefC) {
        ContextoCTFClient contexto = Contexto.getContexto();
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(entradaApiTefC.getFormatoCodigoBarrasEnum(), entradaApiTefC.getCodigoBarras(), contexto.getTipoPagamento());
        if (contexto.getTipoPagamento() == 4 || contexto.getTipoPagamento() == 5) {
            entradaApiTefC.setDadosCorrespondenteBancario(entradaCorrespondenteBancario);
        } else if (contexto.getTipoPagamento() == 1 || contexto.getTipoPagamento() == 2) {
            entradaApiTefC.setInfo(entradaCorrespondenteBancario);
        }
    }

    protected boolean isPagamentoInicial() {
        return this.codigoTransacao.equals("E4") || this.codigoTransacao.equals("E5") || this.codigoTransacao.equals("E6") || this.codigoTransacao.equals("E7");
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) {
        return this.codigoTransacao;
    }
}

