/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import java.util.Collections;
import java.util.List;

public class MicEnvio1FConvenioCombustivel
extends MicAbstractEnvio1F {
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        this.ajustaListProdutoConvenioCombustivelOnEntradaApiTefC();
        String retorno = this.genericExecute(dados);
        this.ajustaListProdutoConvenioCombustivelOnContexto();
        return retorno;
    }

    private void ajustaListProdutoConvenioCombustivelOnContexto() {
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null && saida.getListaProdutosConvenioCombustivel() != null && !saida.getListaProdutosConvenioCombustivel().isEmpty()) {
            Contexto.getContexto().setListProdutosConvenioCombustivelDisponiveis(saida.getListaProdutosConvenioCombustivel());
        }
    }

    private void ajustaListProdutoConvenioCombustivelOnEntradaApiTefC() {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getListProdutoConvenioCombustivel() != null && !entrada.getListProdutoConvenioCombustivel().isEmpty()) {
            List<ProdutoConvenioCombustivel> list = entrada.getListProdutoConvenioCombustivel();
            entrada.setListProdutoConvenioCombustivel(Collections.singletonList(list.get(list.size() - 1)));
        }
    }

    @Override
    protected String getCodigoTransacao(Process dados1F) {
        if (OperationEnum.OP_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6N";
        }
        if (OperationEnum.OP_CONVENIO_COMBUSTIVEL_AUTORIZACAO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            if (Contexto.getContexto().isConvenioCombustivelPosAutorizado()) {
                return "6P";
            }
            return "6O";
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }

    @Override
    protected int getTimeout1F() {
        return 30;
    }
}

