/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MicDesfazimentoOperacaoGeral {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dado) {
        logger = dado.getLoggerFactory().getLogger(CTFClientCore.class);
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        IdentTerminal identTerminal = new IdentTerminal(ident.getNumeroEstabelecimento(), ident.getNumeroLoja(), ident.getNumeroPdv());
        try {
            int i;
            Collection<Object> dadosEntrada = PersistService.getInstance().loadAll(identTerminal);
            if (dadosEntrada == null || dadosEntrada.isEmpty()) {
                SaidaApiTefC saida = new SaidaApiTefC();
                saida.setRetorno(0);
                Contexto.getContexto().setSaidaApiTefC(saida);
                return SUCESS;
            }
            List<DadosConfirmacaoDesfazimento> arrayContrario = this.getDadosConfirmacaoDesfazimentoList(dadosEntrada);
            DadosConfirmacaoDesfazimento dadosDesfazimento = null;
            SaidaApiTefC saida = null;
            for (i = arrayContrario.size() - 1; i >= 0; --i) {
                dadosDesfazimento = arrayContrario.get(i);
                entradaApiTefC.setOperacao(dadosDesfazimento.getOperacao());
                entradaApiTefC.setNumeroTransacao(i + 1);
                entradaApiTefC.setDataCliente(dadosDesfazimento.getDataCliente());
                entradaApiTefC.setNumeroSeriePin(dadosDesfazimento.getNumeroSeriePin());
                entradaApiTefC.setTimeoutCtf(dadosDesfazimento.getTimeout());
                entradaApiTefC.setTimestamp(dadosDesfazimento.getTimestamp());
                if (dadosDesfazimento.getTipoResposta() != null && !dadosDesfazimento.getTipoResposta().equals("")) {
                    entradaApiTefC.setTipoResposta(dadosDesfazimento.getTipoResposta().charAt(0));
                }
                entradaApiTefC.setDadosFinaisChip(dadosDesfazimento.getDadosFinaisChip());
                entradaApiTefC.setIssuerScriptResult(dadosDesfazimento.getIssuerScriptResult());
                if (dadosDesfazimento.getApplicationExpirationDate() != null) {
                    entradaApiTefC.setApplicationExpirationDate(dadosDesfazimento.getApplicationExpirationDate());
                }
                entradaApiTefC.setMotivoDesfazimento(11);
                saida = dado.getApitef().desfazimento(ident, entradaApiTefC);
                if (saida.getRetorno() != 0) continue;
                logger.debug("defazimento da transa\u00e7\u00e3o " + dadosDesfazimento.getNumeroTransacao() + " para o terminal " + identTerminal + " realizada com sucesso.");
                PersistService.getInstance().remove(Integer.toString(dadosDesfazimento.getNumeroTransacao()), identTerminal);
            }
            Contexto.getContexto().setSaidaApiTefC(saida);
            if (saida.getRetorno() != 0) {
                logger.error("n\u00e3o foi poss\u00edvel desfazer a transa\u00e7\u00e3o " + (i + 1) + " (" + dadosDesfazimento.getNumeroTransacao() + ") para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf.");
                return FAIL;
            }
        }
        catch (ExcecaoApiAc e) {
            logger.error(String.format("Nao foi possivel recuperar os dados da transacao para realizar o desfazimento total no terminal %s: %s", identTerminal, e.getMessage()));
            return FAIL;
        }
        return SUCESS;
    }

    private List<DadosConfirmacaoDesfazimento> getDadosConfirmacaoDesfazimentoList(Collection<Object> dadosEntrada) throws ExcecaoApiAc {
        try {
            if (null != dadosEntrada) {
                return (List)dadosEntrada;
            }
            return new ArrayList<DadosConfirmacaoDesfazimento>((List)dadosEntrada);
        }
        catch (ClassCastException e) {
            logger.error("N\u00e3o foi poss\u00edvel realizar o cast do objeto para um Filter: " + e.getMessage());
            throw new ClassCastException(e.getCause().getMessage());
        }
    }
}

