/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;

public class MicDesfazimentoOperacao {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    public static final String ERROR = "ERROR";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dado) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        String key = entradaIntegracao != null ? String.valueOf(entradaIntegracao.getNumeroTransacao()) : String.valueOf(entradaApiTefC.getNumeroTransacao());
        ConfCTFClient conf = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        IdentTerminal identTerminal = new IdentTerminal(ident.getNumeroEstabelecimento(), ident.getNumeroLoja(), ident.getNumeroPdv());
        DadosConfirmacaoDesfazimento dadosConfirmacaoDesfazimento = null;
        try {
            dadosConfirmacaoDesfazimento = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal);
            if (dadosConfirmacaoDesfazimento.isPinpadPOSTefRemoto() && (dadosConfirmacaoDesfazimento.getModoIntegracaoPOSTef() == 2 || dadosConfirmacaoDesfazimento.getModoIntegracaoPOSTef() == 3)) {
                logger.info("transacao executa em modo POSTef com confirmacao no POS habilitada. necessario executar cancelamento da transacao");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_20, "ERRO NO DESFAZIMENTO#USE O CANCELAMENTO");
                Contexto.getContexto().setErroIntegracao(erroIntegracao);
                return ERROR;
            }
            if (conf.isConfirmarDesfazimento() && entradaIntegracao != null && entradaIntegracao.getOperacao() == OperationEnum.OP_DESFAZIMENTO.getKey().intValue() && !this.confirmaDesfazimento(dadosConfirmacaoDesfazimento, dado.getPerifericos())) {
                SaidaApiTefC saida = new SaidaApiTefC();
                saida.setRetorno(20);
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.USERCANCEL, "OPERACAO CANCELADA"));
                return ERROR;
            }
        }
        catch (ExcecaoApiAc e) {
            logger.error(String.format("Nao foi possivel recuperar os dados da transacao para realizar o desfazimento no terminal %s: %s", identTerminal, e.getMessage()));
        }
        if (dadosConfirmacaoDesfazimento != null) {
            entradaApiTefC.setOperacao(dadosConfirmacaoDesfazimento.getOperacao());
            entradaApiTefC.setNumeroTransacao(dadosConfirmacaoDesfazimento.getNumeroTransacao());
            entradaApiTefC.setDataCliente(dadosConfirmacaoDesfazimento.getDataCliente());
            entradaApiTefC.setNumeroSeriePin(dadosConfirmacaoDesfazimento.getNumeroSeriePin());
            entradaApiTefC.setTimeoutCtf(dadosConfirmacaoDesfazimento.getTimeout());
            entradaApiTefC.setTimestamp(dadosConfirmacaoDesfazimento.getTimestamp());
            if (dadosConfirmacaoDesfazimento.getTipoResposta() != null && !dadosConfirmacaoDesfazimento.getTipoResposta().equals("")) {
                entradaApiTefC.setTipoResposta(dadosConfirmacaoDesfazimento.getTipoResposta().charAt(0));
            }
            entradaApiTefC.setDadosFinaisChip(dadosConfirmacaoDesfazimento.getDadosFinaisChip());
            entradaApiTefC.setIssuerScriptResult(dadosConfirmacaoDesfazimento.getIssuerScriptResult());
            if (dadosConfirmacaoDesfazimento.getApplicationExpirationDate() != null) {
                entradaApiTefC.setApplicationExpirationDate(dadosConfirmacaoDesfazimento.getApplicationExpirationDate());
            }
        }
        entradaApiTefC.setMotivoDesfazimento(1);
        SaidaApiTefC saida = dado.getApitef().desfazimento(ident, entradaApiTefC);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            logger.error("n\u00e3o foi poss\u00edvel desfazer a transa\u00e7\u00e3o {} para o terminal {} verifique os arquivos de controle da Apiwebctf.", dadosConfirmacaoDesfazimento != null ? Integer.valueOf(dadosConfirmacaoDesfazimento.getNumeroTransacao()) : "Inexistente", identTerminal);
            return FAIL;
        }
        return SUCESS;
    }

    private boolean confirmaDesfazimento(DadosConfirmacaoDesfazimento dadosDesfazimento, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        LayoutDisplay displayModel = new LayoutDisplay("DESFAZIMENTO DE TRANSACAO");
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha("NSU: " + StringUtil.completaString(dadosDesfazimento.getNsu() + "", 6, '0', 3), 0));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        displayModel.addLinha(new Linha("DATA DA VENDA: " + dateFormat.format(dadosDesfazimento.getDataCliente()), 0));
        if (dadosDesfazimento.getValorTransacao() != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
            displayModel.addLinha(new Linha("VALOR DA VENDA: " + decimalFormat.format(dadosDesfazimento.getValorTransacao()), 0));
        }
        displayModel.addLinha(new Linha("DESFAZER TRANSACAO?", 0, 2));
        displayModel.addLinha(new Linha("[1] - SIM"));
        displayModel.addLinha(new Linha("[2] - NAO"));
        while ((eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_TRANS_PENDENTE)).getTeclaFinalizadora().equals("VOLTA") || !eventoTeclado.getStringLida().equals("1") && !eventoTeclado.getStringLida().equals("2")) {
        }
        if ("1".equals(eventoTeclado.getStringLida())) {
            LayoutDisplay layoutDisplay = new LayoutDisplay("TRANSACAO DESFEITA", ControladorConfCTFClient.TIME_OUT_DELAY);
            perifericos.imprimeDisplay(layoutDisplay);
            return true;
        }
        return false;
    }
}

