/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ILeituraPin;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;

public class MicDesabilitaPIN {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ILeituraPin dados) {
        PinEMV pinEMV;
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            pinEMV = perifericos.getPinpad();
            PerifericoEventHandler.setActive(false);
            if (pinEMV != null) {
                pinEMV.desabilita();
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.error("Erro ao desabilitar o pin: " + excecaoPerifericos.getMessage());
            return ERRO;
        }
        if (perifericos.getEventoNaoEsperadoListener() != null) {
            if (pinEMV != null) {
                pinEMV.removeListener(perifericos.getEventoNaoEsperadoListener());
            }
            perifericos.setEventoNaoEsperadoListener(null);
            perifericos.setEventoNaoEsperado(null);
        }
        return SUCESS;
    }
}

