/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.InformacoesAdicionais;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import java.util.ArrayList;
import java.util.List;

public class MicConfirmaOperacao {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dado) {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        String key = String.valueOf(entradaIntegracao.getNumeroTransacao());
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        IdentTerminal identTerminal = new IdentTerminal(ident.getNumeroEstabelecimento(), ident.getNumeroLoja(), ident.getNumeroPdv());
        try {
            DadosConfirmacaoDesfazimento entrada = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal);
            logger.debug("execute: isPinpadPOSTefRemoto: " + entrada.isPinpadPOSTefRemoto());
            if (entrada.isPinpadPOSTefRemoto() && (entrada.getModoIntegracaoPOSTef() == 2 || entrada.getModoIntegracaoPOSTef() == 3)) {
                logger.info("transacao executa em modo POSTef com confirmacao no POS habilitada.");
                SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                saidaApiTefC.setRetorno(0);
                saidaApiTefC.setCodigoErro(0);
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
                return SUCESS;
            }
            logger.trace("execute: preenchendo dados entrada opera\u00e7\u00e3o");
            entradaApiTefC.setOperacao("80");
            entradaApiTefC.setNumeroTransacao(entrada.getNumeroTransacao());
            entradaApiTefC.setDataCliente(entrada.getDataCliente());
            entradaApiTefC.setNumeroSeriePin(entrada.getNumeroSeriePin());
            entradaApiTefC.setTimeoutCtf(entrada.getTimeout());
            entradaApiTefC.setTimestamp(entrada.getTimestamp());
            entradaApiTefC.setDadosFinaisChip(entrada.getDadosFinaisChip());
            entradaApiTefC.setIssuerScriptResult(entrada.getIssuerScriptResult());
            logger.trace("execute: dados entrada opera\u00e7\u00e3o preenchidos");
        }
        catch (ExcecaoApiAc e) {
            logger.error(String.format("Nao foi poss\u00edvel recuperar os dados da transacao para realizar a confirmacao no terminal %s: %s", identTerminal, e.getMessage()));
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isMadCtrl()) {
            entradaApiTefC.setInformacoesAdicionais(this.formataInformacoesAdicionaisMad(Contexto.getContexto().getEntradaIntegracao().getMad()));
        }
        SaidaApiTefC saida = dado.getApitef().confirmacao(ident, entradaApiTefC);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0 && saida.getRetorno() != 10 && saida.getRetorno() != 13) {
            logger.error("n\u00e3o foi poss\u00edvel confirmar a transa\u00e7\u00e3o " + key + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf.");
            return FAIL;
        }
        logger.debug("confirma\u00e7\u00e3o da transa\u00e7\u00e3o " + entradaApiTefC.getNumeroTransacao() + " para o terminal " + identTerminal + " realizada com sucesso.");
        if (saida.getRetorno() == 10) {
            logger.warn("apitef retornou erro de comunicacao, porem, a transacao esta confirmada no ctfclient e sera sincronizada na proxima transacao.");
            logger.warn("retorno: 10, cod_erro: " + saida.getCodigoErro() + ", alterado para retorno: 0, cod_erro: 0000");
            saida.setRetorno(0);
            saida.setCodigoErro(0);
        }
        return SUCESS;
    }

    private List<InformacoesAdicionais> formataInformacoesAdicionaisMad(String mad) {
        ArrayList<InformacoesAdicionais> listInformacoesAdicionais = new ArrayList<InformacoesAdicionais>();
        listInformacoesAdicionais.add(new InformacoesAdicionais("01", "01", "01", 1, 39, true, false, 0, null, mad.length(), mad, "1", 0));
        return listInformacoesAdicionais;
    }
}

