/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MicConfigureIPCTFServer
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        this.sanitizeIPList();
        boolean isManualOverride = Contexto.getContexto().isManualConfigOverride();
        if (isManualOverride) {
            logger.info("Configura\u00e7\u00e3o manual do IP do CTF.");
        } else if (this.isIPListValid()) {
            logger.info("Configura\u00e7\u00e3o autom\u00e1tica do IP do CTF n\u00e3o \u00e9 necess\u00e1ria. Ignorando.");
            return SUCCESS;
        }
        this.configureCTFServer(dados);
        Contexto.getContexto().setManualConfigOverride(false);
        return SUCCESS;
    }

    private boolean isIPListValid() throws ExcecaoNaoLocal {
        return Objects.requireNonNull(ControladorConfCTFClient.getInstance()).isListaIPValida();
    }

    private void sanitizeIPList() throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        if (confCTFClient == null) {
            return;
        }
        Set ipSet = confCTFClient.getIps();
        if (ipSet == null || ipSet.size() == 0) {
            return;
        }
        ArrayList<Object> ips = new ArrayList<Object>();
        for (Object ip : ipSet.toArray()) {
            if (!this.isValidIPEntry((ServicoCTF)ip)) continue;
            ips.add(ip);
        }
        int diff = ipSet.size() - ips.size();
        if (diff != 0) {
            logger.warn("Removidas " + diff + " configuracoes de IP invalidas.");
            HashSet newSet = new HashSet(ips);
            confCTFClient.setIps(newSet);
            ControladorConfCTFClient.getInstance().save(confCTFClient);
        }
    }

    private boolean isValidIPEntry(ServicoCTF entry) {
        if (entry.getProtocolo() == null || entry.getProtocolo().length() < 1) {
            return false;
        }
        if (entry.getIdentificadorServico() == null || entry.getIdentificadorServico().length() < 1) {
            return false;
        }
        return entry.getHost() != null && entry.getHost().getEndereco() != null && entry.getHost().getEndereco().length() >= 1;
    }

    private void configureCTFServer(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos peripherals = dados.getPerifericos();
        boolean exitLoop = false;
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        Set ips = confCTFClient.getIps();
        block12: while (!exitLoop) {
            LayoutMenu layoutMenu = new LayoutMenu("CONFIGURACAO -> CTF-SERVER", true);
            this.addLayoutMenu(layoutMenu, new ItemMenu[]{new ItemMenu("LISTAR", "1"), new ItemMenu("ADICIONAR", "2"), new ItemMenu("REMOVER", "3"), new ItemMenu("VOLTAR", "4")});
            int printMenuSelected = ips == null || ips.isEmpty() ? 2 : peripherals.imprimeMenu(layoutMenu);
            if (printMenuSelected == -1) {
                exitLoop = true;
                continue;
            }
            switch (printMenuSelected) {
                case 1: {
                    try {
                        this.configureCTFServerOpcao01(peripherals);
                    }
                    catch (ExcecaoApiAc e) {
                        logger.error("Erro na op\u00e7\u00e3o 1: " + printMenuSelected);
                        logger.error(e.getMessage());
                    }
                    break;
                }
                case 2: {
                    try {
                        this.configureCTFServerOpcao02(peripherals);
                        if (Contexto.getContexto().isManualConfigOverride()) continue block12;
                        exitLoop = true;
                    }
                    catch (ExcecaoApiAc e) {
                        logger.error("Erro na op\u00e7\u00e3o 2: " + printMenuSelected);
                        logger.error(e.getMessage());
                    }
                    break;
                }
                case 3: {
                    try {
                        this.configureCTFServerOpcao03(peripherals);
                    }
                    catch (ExcecaoApiAc e) {
                        logger.error("Erro na op\u00e7\u00e3o 3: " + printMenuSelected);
                        logger.error(e.getMessage());
                    }
                    break;
                }
                case 4: {
                    exitLoop = true;
                }
            }
        }
    }

    private void delLayoutMenu(ControladorPerifericos peripherals, ConfCTFClient confCTFClient, int printMenuSelected, int layoutMenuItem, Set<?> ips) throws ExcecaoApiAc {
        for (Object obj : ips) {
            if (layoutMenuItem == printMenuSelected) {
                confCTFClient.getIps().remove(obj);
                Objects.requireNonNull(ControladorConfCTFClient.getInstance()).save(confCTFClient);
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("CTF-SERVER REMOVIDO"));
                peripherals.confirmaDado(layoutDisplay);
                break;
            }
            ++layoutMenuItem;
        }
    }

    private void addLayoutMenu(LayoutMenu layoutMenu, ItemMenu[] listItemMenu) {
        for (ItemMenu ItemMenu2 : listItemMenu) {
            layoutMenu.addItem(ItemMenu2);
        }
    }

    private void addLayoutMenu(LayoutMenu layoutMenu, Integer layoutMenuItem, Set<?> ips) {
        for (Object obj : ips) {
            ServicoCTF servicoCTF = (ServicoCTF)obj;
            String ctf = servicoCTF.getHost().getEndereco();
            ctf = ctf + ":" + servicoCTF.getIdentificadorServico();
            ctf = ctf + ":" + servicoCTF.getProtocolo();
            Integer n = layoutMenuItem;
            Integer n2 = layoutMenuItem = Integer.valueOf(layoutMenuItem + 1);
            layoutMenu.addItem(new ItemMenu(ctf, "" + n));
        }
    }

    private void configureCTFServerOpcao01(ControladorPerifericos peripherals) throws ExcecaoApiAc {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        Set ips = confCTFClient.getIps();
        LayoutMenu layoutMenu = new LayoutMenu("CTF-SERVER -> LISTAR", true);
        int layoutMenuItem = 1;
        this.addLayoutMenu(layoutMenu, layoutMenuItem, ips);
        peripherals.imprimeMenu(layoutMenu);
    }

    private void configureCTFServerOpcao02(ControladorPerifericos peripherals) throws ExcecaoApiAc {
        EventoTeclado keyboardEvent;
        LayoutDisplay layoutDisplay;
        boolean exitLoop = false;
        boolean validatedHost = false;
        String hostAddress = "";
        int portAddress = 0;
        String protocolAddress = "";
        while (!exitLoop && !validatedHost) {
            layoutDisplay = new LayoutDisplay("CTF-SERVER -> ADICIONAR");
            layoutDisplay.addLinha(new Linha("HOST:"));
            keyboardEvent = (EventoTeclado)peripherals.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CTF_HOST);
            if (keyboardEvent.getTeclaFinalizadora().equals("VOLTA")) {
                exitLoop = true;
                continue;
            }
            hostAddress = keyboardEvent.getStringLida().trim();
            if (hostAddress.length() == 0) continue;
            layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha("VALIDANDO HOST"));
            layoutDisplay.addLinha(new Linha("AGUARDE..."));
            peripherals.imprimeDisplay(layoutDisplay);
            try {
                InetAddress address = InetAddress.getByName(hostAddress);
                if (address == null) continue;
                validatedHost = true;
            }
            catch (UnknownHostException e) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("HOST INVALIDO"));
                peripherals.confirmaDado(layoutDisplay);
                validatedHost = false;
            }
        }
        while (!exitLoop && portAddress <= 0) {
            layoutDisplay = new LayoutDisplay("CTF-SERVER -> ADICIONAR");
            layoutDisplay.addLinha(new Linha("PORTA:"));
            keyboardEvent = (EventoTeclado)peripherals.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CTF_PORTA);
            if (keyboardEvent.getTeclaFinalizadora().equals("VOLTA")) {
                exitLoop = true;
                continue;
            }
            portAddress = Integer.parseInt(keyboardEvent.getStringLida().trim());
        }
        int printMenuSelected = 0;
        while (!exitLoop && printMenuSelected == 0) {
            String[] msg = new String[]{"CTF-SERVER > ADICIONAR", "PROTOCOLO:"};
            LayoutMenu layoutMenu = new LayoutMenu(msg, true);
            layoutMenu.addItem(new ItemMenu("TCP", "1"));
            layoutMenu.addItem(new ItemMenu("UDP", "2"));
            printMenuSelected = peripherals.imprimeMenu(layoutMenu);
            if (printMenuSelected == 1) {
                protocolAddress = "TCP";
                continue;
            }
            if (printMenuSelected != 2) continue;
            protocolAddress = "UDP";
        }
        if (!exitLoop) {
            ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            Host host = new Host(hostAddress);
            ServicoCTF servicoCTF = new ServicoCTF(host, portAddress + "", protocolAddress);
            if (confCTFClient.getIps() == null) {
                confCTFClient.setIps(new HashSet());
            }
            if (!confCTFClient.getIps().contains(servicoCTF)) {
                confCTFClient.getIps().add(servicoCTF);
                ControladorConfCTFClient.getInstance().save(confCTFClient);
            }
            LayoutDisplay layoutDisplay2 = new LayoutDisplay();
            layoutDisplay2.addLinha(new Linha("CTF-SERVER ADICIONADO"));
            peripherals.confirmaDado(layoutDisplay2);
        }
    }

    private void configureCTFServerOpcao03(ControladorPerifericos peripherals) throws ExcecaoApiAc {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        Set ips = confCTFClient.getIps();
        LayoutMenu layoutMenu = new LayoutMenu("CTF-SERVER -> REMOVER", true);
        int layoutMenuItem = 1;
        this.addLayoutMenu(layoutMenu, layoutMenuItem, ips);
        int printMenuSelected = peripherals.imprimeMenu(layoutMenu);
        if (printMenuSelected != -1) {
            if (ips.size() == 1) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL REMOVER"));
                layoutDisplay.addLinha(new Linha("O CTF-SERVER SELECIONADO"));
                layoutDisplay.addLinha(new Linha("DETALHE:", 0, 1));
                layoutDisplay.addLinha(new Linha("DEVE EXISTIR PELO MENOS"));
                layoutDisplay.addLinha(new Linha("UM CTF-SERVER CONFIGURADO"));
                peripherals.confirmaDado(layoutDisplay);
            } else {
                layoutMenu = new LayoutMenu("REMOVER CTF-SERVER?", true);
                layoutMenu.addItem(new ItemMenu("SIM", "1"));
                layoutMenu.addItem(new ItemMenu("NAO", "2"));
                printMenuSelected = peripherals.imprimeMenu(layoutMenu);
                if (printMenuSelected == 1) {
                    layoutMenuItem = 1;
                    this.delLayoutMenu(peripherals, confCTFClient, printMenuSelected, layoutMenuItem, ips);
                }
            }
        }
    }
}

