/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.model.ProdutoSimulacaoCrediario;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.Language;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicComprovanteSimulacaoCrediario {
    public static final String COMPROVANTES_GERADOS = "COMPROVANTES_GERADOS";
    public static final String PERGUNTA_NOVA_SIMULACAO = "PERGUNTA_NOVA_SIMULACAO";

    private void gerarComprovantes(Process processo) {
        ProdutoSimulacaoCrediario produto = Contexto.getContexto().getProdutoSimulacaoCrediarioSelecionado();
        if (produto != null) {
            processo.getApitef().insereSubcampoSaida(162, produto.getCupom(38));
        }
    }

    public String execute(Process processo) throws ExcecaoNaoLocal {
        Language lang = InternacionalizacaoUtil.getInstance().getLanguage();
        if (OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            String msgImprimir = lang.getMessage(MessageEnum.SIMULACAO_CREDIARIO_PERGUNTA_IMPRIMIR);
            if (processo.getPerifericos().perguntaSimNao(processo, msgImprimir)) {
                this.gerarComprovantes(processo);
                return COMPROVANTES_GERADOS;
            }
            return PERGUNTA_NOVA_SIMULACAO;
        }
        String msgImprimir = lang.getMessage(MessageEnum.SIMULACAO_CREDIARIO_PERGUNTA_CONTRATAR);
        if (processo.getPerifericos().perguntaSimNao(processo, msgImprimir)) {
            this.gerarComprovantes(processo);
            return COMPROVANTES_GERADOS;
        }
        return PERGUNTA_NOVA_SIMULACAO;
    }
}

