/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.TrataLegadoUtil;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicCapturaValorDocumentoCorBan {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String CONFIRM_VALUE = "CONFIRM_VALUE";
    public static final String INVALID_CONFIRMATION = "INVALID_CONFIRMATION";
    public static final String INVALID_CONFIRMATION_AC = "INVALID_CONFIRMATION_AC";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        BigDecimal valor;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_PAGAMENTO_FATURA_CARTAO.getDescription()) && entrada.getValorTransacao() == null && Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl()) {
            logger.info("Assumindo o valor da integra\u00e7\u00e3o como o da transa\u00e7\u00e3o e do documento");
            entrada.setValorTransacao(Contexto.getContexto().getEntradaIntegracao().getValorTransacao());
            entrada.setValorDocumento(Contexto.getContexto().getEntradaIntegracao().getValorTransacao());
            return SUCESS;
        }
        if (entrada.getValorDocumento() != null && !Contexto.getContexto().isConfirmaValorDocumento()) {
            return FILLED;
        }
        BigDecimal valorTransacaoIntegracao = null;
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl()) {
                if (entrada.getValorDocumento() != null) {
                    if (Contexto.getContexto().getEntradaIntegracao().getValorTransacao().compareTo(entrada.getValorDocumento()) == 0) {
                        return SUCESS;
                    }
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage(MessageEnum.CAPVALDOC_INVALID_CONFIRMATION)));
                    return INVALID_CONFIRMATION_AC;
                }
                entrada.setValorDocumento(Contexto.getContexto().getEntradaIntegracao().getValorTransacao());
            }
        } else {
            valorTransacaoIntegracao = TrataLegadoUtil.calculaValorTransacao(dados);
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorTransacaoCtrl()) {
            if (Contexto.getContexto().getEntradaIntegracao().getValorTransacao().equals(entrada.getValorDocumento())) {
                return SUCESS;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage(MessageEnum.CAPVALDOC_INVALID_CONFIRMATION)));
            return INVALID_CONFIRMATION_AC;
        }
        if (saida != null && saida.isExigeConfirmacaoValorDocumento()) {
            BigDecimal valor2 = null;
            if (valorTransacaoIntegracao != null && Contexto.getContexto().isConfirmaValorDocumento()) {
                valor2 = valorTransacaoIntegracao;
            } else {
                try {
                    valor2 = this.solicitaValorUsuario(perifericos);
                }
                catch (UserCancelException e) {
                    return USER_CANCEL;
                }
                catch (invalidNumberException e) {
                    return INVALID_NUMBER;
                }
            }
            if (!Contexto.getContexto().isConfirmaValorDocumento()) {
                entrada.setValorDocumento(valor2);
                Contexto.getContexto().setConfirmaValorDocumento(true);
                return CONFIRM_VALUE;
            }
            if (valor2.equals(entrada.getValorDocumento())) {
                return SUCESS;
            }
            if (valorTransacaoIntegracao != null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage(MessageEnum.CAPVALDOC_INVALID_CONFIRMATION)));
                return INVALID_CONFIRMATION_AC;
            }
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage(MessageEnum.CAPVALDOC_INVALID_CONFIRMATION));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            if (!Contexto.getContexto().isValorDocumentoCapturado()) {
                entrada.setValorDocumento(null);
                Contexto.getContexto().setConfirmaValorDocumento(false);
            }
            return INVALID_CONFIRMATION;
        }
        if (entrada.getValorDocumento() != null) {
            if (valorTransacaoIntegracao != null && !valorTransacaoIntegracao.equals(entrada.getValorDocumento())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage(MessageEnum.CAPVALDOC_INVALID_CONFIRMATION)));
                return INVALID_CONFIRMATION_AC;
            }
            DecimalFormat format = new DecimalFormat("#,##0.00");
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage(MessageEnum.CAPVALDOC_DOC_VALUE) + " " + format.format(entrada.getValorDocumento()));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            TrataLegadoUtil.calculaValorTransacao(dados, entrada.getValorDocumento());
            return SUCESS;
        }
        if (valorTransacaoIntegracao != null) {
            valor = valorTransacaoIntegracao;
        } else {
            try {
                valor = this.solicitaValorUsuario(perifericos);
            }
            catch (UserCancelException e) {
                return USER_CANCEL;
            }
            catch (invalidNumberException e) {
                return INVALID_NUMBER;
            }
        }
        entrada.setValorDocumento(valor);
        TrataLegadoUtil.calculaValorTransacao(dados, valor);
        return SUCESS;
    }

    private BigDecimal solicitaValorUsuario(ControladorPerifericos perifericos) throws ExcecaoNaoLocal, UserCancelException, invalidNumberException {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage(MessageEnum.CAPVALDOC_TITLE));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_DOCUMENTO, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new UserCancelException();
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            throw new invalidNumberException();
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            throw new invalidNumberException();
        }
        valor = valor.movePointLeft(2);
        return valor;
    }

    private EventoDispositivoEntrada exibeMensagem(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        return perifericos.confirmaDado(displayModel);
    }

    class invalidNumberException
    extends Exception {
        private static final long serialVersionUID = 2L;

        invalidNumberException() {
        }
    }

    class userCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        userCancelException() {
        }
    }
}

