/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.ArrayList;

public class MicCapturaTipoPagamentoDinamico {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    private static final String TIPO_PAGAMENTO_NAO_HABILITADO = "NENHUMA MODALIDADE DE PAGAMENTO HABILITADA";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getTipoPagamento() > 0) {
            return FILLED;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        CorrespondenteBancario corban = Contexto.getContexto().getCorrespondenteBancario();
        if (entradaIntegracao != null && entradaIntegracao.isFormaPagamentoContasCtrl()) {
            int formaPagamentoContas = entradaIntegracao.getFormaPagamentoContas();
            if (corban == null) {
                if (formaPagamentoContas >= 1 && formaPagamentoContas <= 6) {
                    Contexto.getContexto().setTipoPagamento(entradaIntegracao.getFormaPagamentoContas());
                    return SUCESS;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.FORMA_PAGAMENTO_INVALIDA, "FORMA DE PAGAMENTO INVALIDA"));
                return ERROR_AC;
            }
            if (corban.isPagamentoDinheiro() && formaPagamentoContas == 1 || corban.isPagamentoCheque() && formaPagamentoContas == 2 || corban.isPagamentoChequeBanco() && formaPagamentoContas == 3 || corban.isPagamentoDebito() && formaPagamentoContas == 4 || corban.isPagamentoCredito() && formaPagamentoContas == 5 || corban.isPagamentoCartaoProprio() && formaPagamentoContas == 6) {
                Contexto.getContexto().setTipoPagamento(entradaIntegracao.getFormaPagamentoContas());
                return SUCESS;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.FORMA_PAGAMENTO_INVALIDA, "FORMA DE PAGAMENTO INVALIDA"));
            return ERROR_AC;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ArrayList<TipoPagamento> listPagamentos = new ArrayList<TipoPagamento>();
        if (corban == null || corban != null && corban.isPagamentoDinheiro()) {
            listPagamentos.add(new TipoPagamento(1, inter.getMessage(MessageEnum.CAPTIPPAGDIN_PAGAMENTO_DINHEIRO)));
        }
        if (corban == null || corban != null && corban.isPagamentoCheque()) {
            listPagamentos.add(new TipoPagamento(2, inter.getMessage(MessageEnum.CAPTIPPAGDIN_PAGAMENTO_CHEQUE)));
        }
        if (corban == null || corban != null && corban.isPagamentoChequeBanco()) {
            listPagamentos.add(new TipoPagamento(3, inter.getMessage(MessageEnum.CAPTIPPAGDIN_PAGAMENTO_CHEQUE_BANCO)));
        }
        if (corban == null || corban != null && corban.isPagamentoDebito()) {
            listPagamentos.add(new TipoPagamento(4, inter.getMessage(MessageEnum.CAPTIPPAGDIN_PAGAMENTO_DEBITO)));
        }
        if (corban == null || corban != null && corban.isPagamentoCredito()) {
            listPagamentos.add(new TipoPagamento(5, inter.getMessage(MessageEnum.CAPTIPPAGDIN_PAGAMENTO_CREDITO)));
        }
        if (corban == null || corban != null && corban.isPagamentoCartaoProprio()) {
            listPagamentos.add(new TipoPagamento(6, inter.getMessage(MessageEnum.CAPTIPPAGDIN_PAGAMENTO_CARTAO_PROPRIO)));
        }
        if (listPagamentos.isEmpty()) {
            logger.error("Nenhuma forma de pagamento foi habilitada no concentrador para o pagamento da conta.");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_PAGAMENTO_NAO_HABILITADO, TIPO_PAGAMENTO_NAO_HABILITADO));
            return ERROR;
        }
        Object[] arrayPagamentos = listPagamentos.toArray();
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPTIPPAG_TITLE), true);
        int iTecla = 1;
        for (int i = 0; i < arrayPagamentos.length; ++i) {
            layoutMenu.addItem(new ItemMenu(((TipoPagamento)arrayPagamentos[i]).getDescricao(), String.valueOf(iTecla++)));
        }
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        Contexto.getContexto().setTipoPagamento(((TipoPagamento)arrayPagamentos[opcao - 1]).getId());
        return SUCESS;
    }

    private class TipoPagamento {
        private int id;
        private String descricao;

        public TipoPagamento(int id, String descricao) {
            this.id = id;
            this.descricao = descricao;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public int getId() {
            return this.id;
        }
    }
}

