/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaTipoGarantia {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String INVALID_TRANSACTION_AC = "INVALID_TRANSACTION_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean habilitado;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (entradaApiTefC.getTipoGarantia() != -1) {
            return FILLED;
        }
        if (saidaApiTefC.getHabilitaCDC_PRE() == 2) {
            return UNECESSARY;
        }
        boolean bl = habilitado = saidaApiTefC.getHabilitaCDC_PRE() == 1;
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isTipoGarantiaCtrl()) {
            if (habilitado) {
                entradaApiTefC.setTipoGarantia(Contexto.getContexto().getEntradaIntegracao().getTipoGarantia());
            } else {
                if (Contexto.getContexto().getEntradaIntegracao().getTipoGarantia() == 2) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPTIPGAR_INVALID_TRANSACTION, inter.getMessage(MessageEnum.CAPTIPGAR_INVALID_TRANSACTION)));
                    return INVALID_TRANSACTION_AC;
                }
                entradaApiTefC.setTipoGarantia(1);
            }
        } else {
            if (!habilitado) {
                LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPTIPGAR_VENDA_GARANTIDA), ControladorConfCTFClient.TIME_OUT_DELAY);
                perifericos.imprimeDisplay(displayModel);
                entradaApiTefC.setTipoGarantia(1);
                return UNECESSARY;
            }
            if (entradaApiTefC.getTipoGarantia() == -1 && habilitado) {
                LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPTIPGAR_TITLE));
                displayModel.addLinha(new Linha("[1] - COM GARANTIA"));
                displayModel.addLinha(new Linha("[2] - SEM GARANTIA"));
                boolean continuar = true;
                while (continuar) {
                    EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_TIPO_GARANTIA);
                    if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                        return USERCANCEL;
                    }
                    int opcao = Integer.parseInt(eventoTeclado.getStringLida());
                    switch (opcao) {
                        case 1: {
                            entradaApiTefC.setTipoGarantia(1);
                            continuar = false;
                            break;
                        }
                        case 2: {
                            entradaApiTefC.setTipoGarantia(2);
                            continuar = false;
                        }
                    }
                }
            }
        }
        return SUCESS;
    }
}

