/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaTipoFinanciamentoCreditoCelular {
    public static final String SUCESS_AVISTA = "SUCESS_AVISTA";
    public static final String SUCESS_APRAZOLOJISTA = "SUCESS_APRAZOLOJISTA";
    public static final String SUCESS_APRAZOADMINISTRADO = "SUCESS_APRAZOADMINISTRADO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String FINANCIAMENTO_INVALIDO_AC = "FINANCIAMENTO_INVALIDO_AC";
    private static final String TIPO_FINANCIAMENTO_NAO_COERENTE = "O TIPO DE FINANCIAMENTO NAO E COERENTE COM O NUMERO DE PARCELAS";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";

    /*
     * Enabled aggressive block sorting
     */
    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean buscaEntrada;
        EntradaCTFClientCtrl entradaIntegracao;
        boolean habilitadoAdministradora;
        boolean habilitadoFinanciadoLojista;
        boolean habilitadoAVista;
        InternacionalizacaoUtil inter;
        block25: {
            block26: {
                block27: {
                    if (Contexto.getContexto().getPlano() != null) {
                        return FILLED;
                    }
                    inter = InternacionalizacaoUtil.getInstance();
                    SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
                    habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
                    habilitadoFinanciadoLojista = saidaApiTefC.isPedePlanoLojista();
                    habilitadoAdministradora = saidaApiTefC.isPedePlanoAdministradora();
                    entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                    if (entradaIntegracao == null) break block26;
                    if (entradaIntegracao.getOperacao() != OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey().intValue()) break block27;
                    if (entradaIntegracao.isNumeroParcelasCtrl()) {
                        if (entradaIntegracao.getNumeroParcelas() == 0) {
                            buscaEntrada = false;
                            break block25;
                        } else {
                            if (entradaIntegracao.getNumeroParcelas() != 1) {
                                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_FINANCIAMENTO_NAO_COERENTE, TIPO_FINANCIAMENTO_NAO_COERENTE));
                                return FINANCIAMENTO_INVALIDO_AC;
                            }
                            buscaEntrada = true;
                        }
                        break block25;
                    } else {
                        buscaEntrada = false;
                    }
                    break block25;
                }
                if (entradaIntegracao.getOperacao() != OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey().intValue()) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
                    return ERROR_AC;
                }
                if (entradaIntegracao.isNumeroParcelasCtrl() && entradaIntegracao.getNumeroParcelas() == 1) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_FINANCIAMENTO_NAO_COERENTE, TIPO_FINANCIAMENTO_NAO_COERENTE));
                    return FINANCIAMENTO_INVALIDO_AC;
                }
                buscaEntrada = true;
                break block25;
            }
            buscaEntrada = false;
        }
        if (buscaEntrada) {
            int operacao = entradaIntegracao.getOperacao();
            if (operacao == OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey()) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (operacao == OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey()) {
                Contexto.getContexto().setPlano(Plano.LOJISTA);
                return SUCESS_APRAZOLOJISTA;
            }
            if (operacao == OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey()) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SUCESS_APRAZOADMINISTRADO;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
            return ERROR_AC;
        }
        int iTecla = 1;
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.LEITIPFINCRE_TITLE), true);
        if (habilitadoAVista) {
            layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_AVISTA), String.valueOf(iTecla++)));
        }
        if (habilitadoAdministradora) {
            layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_ADMINISTRADORA), String.valueOf(iTecla++)));
        }
        if (habilitadoFinanciadoLojista) {
            layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_FINANCIADO_LOJISTA), String.valueOf(iTecla++)));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (layoutMenu.getItens().isEmpty()) {
            Contexto.getContexto().setPlano(null);
            return ERROR;
        }
        if (layoutMenu.getItens().size() == 1) {
            if (habilitadoAVista) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (habilitadoAdministradora) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SUCESS_APRAZOADMINISTRADO;
            }
            if (!habilitadoFinanciadoLojista) return ERROR;
            Contexto.getContexto().setPlano(Plano.LOJISTA);
            return SUCESS_APRAZOLOJISTA;
        } else {
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_AVISTA))) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SUCESS_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_FINANCIADO_LOJISTA))) {
                Contexto.getContexto().setPlano(Plano.LOJISTA);
                return SUCESS_APRAZOLOJISTA;
            }
            if (!itemSelecionado.getTexto().equals(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_ADMINISTRADORA))) return ERROR;
            Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
            return SUCESS_APRAZOADMINISTRADO;
        }
    }
}

