/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaTipoConsultaCredito {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_TIPO_CONSULTA_AC = "INVALID_TIPO_CONSULTA_AC";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaApiTefC.getTipoConsultaCredito() != 0) {
            return FILLED;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isTipoConsultaSpcCtrl()) {
                int tipoConsultaSpc = entradaIntegracao.getTipoConsultaSpc();
                if (tipoConsultaSpc == 1 || tipoConsultaSpc == 2) {
                    entradaApiTefC.setTipoConsultaCredito(tipoConsultaSpc);
                    return SUCCESS;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_CONSULTA_SPC_INVALIDO, "O tipo da consulta SPC \u00e9 inv\u00e1lido, utilizar 1 \u0096 Autom\u00e1tica ou 2 \u0096 mandat\u00f3ria"));
                return INVALID_TIPO_CONSULTA_AC;
            }
            if (entradaIntegracao.isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_CONSULTA_SPC_INVALIDO, "O tipo da consulta SPC \u00e9 inv\u00e1lido, utilizar 1 \u0096 Autom\u00e1tica ou 2 \u0096 mandat\u00f3ria"));
                return INVALID_TIPO_CONSULTA_AC;
            }
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPTIPCONSPC_TITLE), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.CAPTIPCONSPC_CONSULTA_AUTOMATICA), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.CAPTIPCONSPC_CONSULTA_MANDATORIA), "2"));
        int opcao = periferico.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        switch (opcao) {
            case 1: {
                entradaApiTefC.setTipoConsultaCredito(1);
                break;
            }
            case 2: {
                entradaApiTefC.setTipoConsultaCredito(2);
            }
        }
        return SUCCESS;
    }
}

