/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnicaManual;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaTelefoneEstabelecimento {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        DadosBaixaTecnicaManual dadosBaixaTecnicaManual = Contexto.getContexto().getBaixaTecnicaManual();
        if (dadosBaixaTecnicaManual.getTelefoneEstabelecimento() != null) {
            return FILLED;
        }
        String numTelefoneEstabelecimento = "";
        boolean tamanhoInvalido = true;
        while (tamanhoInvalido) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPTELEST_TITLE));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_TELEFONE_ESTABELECIMENTO, 0, true, 14, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getNumCaracteresDigitados();
            numTelefoneEstabelecimento = eventoTeclado.getStringLida().substring(0, num);
            if (numTelefoneEstabelecimento.length() != 10) continue;
            tamanhoInvalido = false;
        }
        dadosBaixaTecnicaManual.setTelefoneEstabelecimento(numTelefoneEstabelecimento);
        return SUCESS;
    }
}

