/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.ArrayList;
import java.util.Iterator;

public class MicCapturaPrazo1aParcela {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getDiasPrimeiraParcela() >= 0) {
            return FILLED;
        }
        ArrayList<PrazoAgendamento> listPrazos = new ArrayList<PrazoAgendamento>();
        listPrazos.add(new PrazoAgendamento(30, "30 DIAS"));
        listPrazos.add(new PrazoAgendamento(60, "60 DIAS"));
        if (listPrazos == null || listPrazos.isEmpty()) {
            logger.error("Erro ao capturar a lista de prazos de agendamento da primeira parcela, a lista est\u00e1 nula ou vazia.");
            throw new IllegalArgumentException("Lista de prazos nula");
        }
        Iterator ite = listPrazos.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPPRA1APAR_TITLE), true);
        PrazoAgendamento[] arrayPrazosAgendamento = new PrazoAgendamento[listPrazos.size()];
        int iTecla = 0;
        while (ite.hasNext()) {
            PrazoAgendamento prazoAgendamento;
            arrayPrazosAgendamento[iTecla] = prazoAgendamento = (PrazoAgendamento)ite.next();
            layoutMenu.addItem(new ItemMenu(prazoAgendamento.getDescricao(), String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        entradaApiTefC.setDiasPrimeiraParcela(arrayPrazosAgendamento[opcao - 1].getCodigo());
        return SUCCESS;
    }

    class PrazoAgendamento {
        private int codigo;
        private String descricao;

        public PrazoAgendamento() {
        }

        public PrazoAgendamento(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public int getCodigo() {
            return this.codigo;
        }

        public void setCodigo(int codigo) {
            this.codigo = codigo;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }
    }
}

